import { defineStore } from 'pinia';
import { reactive, Ref } from 'vue';
import { useZIndexStore } from './z-index';

export interface IUIState {
  /**
   * ui层级
   *
   * @author lxm
   * @date 2022-08-18 21:08:48
   * @type {number}
   */
  zIndex: Ref<number>;
}

export const useUIStore = defineStore('uiStore', () => {
  const zIndex = useZIndexStore();

  const UIStore = reactive<IUIState>({
    zIndex: zIndex.zIndex,
  });

  return { UIStore, zIndex };
});
