import { defineComponent } from 'vue';
import {
  getGridEditorEmits,
  getGridRadioProps,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';

export const IBizGridRadio = defineComponent({
  name: 'IBizGridRadio',
  props: getGridRadioProps(),
  emits: getGridEditorEmits(),
  setup(props, { emit }) {
    const ns = useNamespace('grid-radio');
    const { isInfoMode, componentRef, onOperateChange, onChange, onBlur } =
      useGridCellEditor(props, {
        emit,
      });

    const onRadioChange = async (val: unknown, name?: string) => {
      await onChange(val, name);
      // 选中后就失焦
      onBlur();
    };

    return {
      ns,
      isInfoMode,
      componentRef,
      onOperateChange,
      onRadioChange,
    };
  },
  render(h) {
    return (
      <grid-editor
        disabled={this.disabled}
        readonly={this.readonly}
        ref='componentRef'
        class={`${this.ns.b()}`}
      >
        {h('IBizRadio', {
          props: {
            ...this.$props,
            readonly: this.isInfoMode,
            disabled: this.disabled,
          },
          on: {
            change: this.onRadioChange,
            operate: this.onOperateChange,
          },
        })}
      </grid-editor>
    );
  },
});
