import { useViewStack } from '@ibiz-template/mob-vue3-components';
import { routerCallback } from '@ibiz-template/vue3-util';
import { Modal, ViewMode } from '@ibiz-template/runtime';
import { defineComponent, onUnmounted, ref } from 'vue';
import './App.scss';

export default defineComponent({
  setup() {
    const { viewStack, on, off, goBack } = useViewStack();
    const transitionName = ref('forward');
    const onViewStackChange = (type: 'push' | 'pop') => {
      transitionName.value = type === 'push' ? 'forward' : 'back';
    };

    on('onBeforeStackChange', onViewStackChange);

    onUnmounted(() => {
      off('onBeforeStackChange', onViewStackChange);
    });

    const viewModals = new Map<string, Modal>();

    const getViewModal = (key: string) => {
      if (!viewModals.has(key)) {
        viewModals.set(
          key,
          new Modal({
            mode: ViewMode.ROUTE,
            viewUsage: 1,
            routeDepth: 1,
            dismiss: modal => {
              routerCallback.close(key, modal);
              goBack();
              viewModals.delete(key);
            },
          }),
        );
      }
      return viewModals.get(key);
    };

    return {
      viewStack,
      getViewModal,
      transitionName,
    };
  },
  render() {
    return (
      <iBizRouterView
        manualKey={this.viewStack.currentKey}
        modal={this.getViewModal(this.viewStack.currentKey)}
      >
        {({ Component }: { Component: string }) => {
          return (
            <iBizKeepAlive keyList={this.viewStack.cacheKeys}>
              {Component && <Component />}
            </iBizKeepAlive>
          );
        }}
      </iBizRouterView>
    );
  },
});
