import { AppMenuPortletController } from '@ibiz-template/controller';
import { AppMenuPortletModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent } from 'vue';

export const AppMenuPortlet = defineComponent({
  name: 'AppMenuPortlet',
  props: {
    modelData: {
      type: AppMenuPortletModel,
      required: true,
    },
    controller: {
      type: AppMenuPortletController,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('app-menu-portlet');
    return { ns };
  },
  render() {
    const classArr: string[] = [
      this.ns.b(),
      this.ns.m(this.modelData.modelClass),
    ];
    const header: unknown = null;
    return (
      <div class={classArr}>
        {header}
        <div class={[this.ns.b('content')]}>{this.modelData.modelClass}</div>
      </div>
    );
  },
});
