import {
  IGridColumnProvider,
  GridController,
  GridGroupColumnController,
} from '@ibiz-template/controller';
import { GridGroupColumnModel } from '@ibiz-template/model';
/**
 * 表格分组列适配器
 *
 * @export
 * @class GridGroupColumnProvider
 * @implements {IGridColumnProvider}
 */
export class GridGroupColumnProvider implements IGridColumnProvider {
  component: string = '';

  async createController(
    columnModel: GridGroupColumnModel,
    grid: GridController,
  ): Promise<GridGroupColumnController> {
    const c = new GridGroupColumnController(columnModel, grid);
    await c.init();
    return c;
  }
}
