import { EntityProxyMiddleware } from '../../core';
import { MiddlewareConsumer, Module, NestModule } from '@nestjs/common';
import { BookController } from './book.controller';

export class BookMiddleware extends EntityProxyMiddleware {
  protected serviceTag = 'book';
}

@Module({
  controllers: [BookController]
})
export class BookModule implements NestModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(BookMiddleware).forRoutes('(.*)/importdata', '(.*)/importtemplate', '(.*)/exportdata/(.*)');
  }
}

