import { Controller, Request, Post, Body, Get, Param, HttpStatus, Req, Res } from '@nestjs/common';
import { FastifyRequest, FastifyReply } from 'fastify';
import { AuthService } from './auth.service';

/**
 * 认证接口
 *
 * @author chitanda
 * @date 2021-08-26 10:08:33
 * @export
 * @class AuthController
 */
@Controller()
export class AuthController {
  /**
   * Creates an instance of AuthController.
   *
   * @author chitanda
   * @date 2021-08-17 20:08:02
   * @param {AuthService} authService
   */
  constructor(private readonly authService: AuthService) { }

  /**
   * 登录
   *
   * @author chitanda
   * @date 2021-08-26 09:08:16
   * @param {FastifyRequest} req
   * @param {FastifyReply} res
   * @param {string} loginname
   * @param {string} password
   * @return {*}  {Promise<any>}
   */
  @Post('/v7/login')
  async login(
    @Req() req: FastifyRequest,
    @Res() res: FastifyReply,
    @Body('loginname') loginname: string,
    @Body('password') password: string,
  ): Promise<any> {
    const data = await this.authService.login(req, res, loginname, password);
    res.status(HttpStatus.OK).send(data);
  }

  /**
   * 登出
   *
   * @author chitanda
   * @date 2021-08-26 09:08:16
   * @param {FastifyRequest} req
   * @param {FastifyReply} res
   * @return {*}  {Promise<any>}
   */
  @Get('/v7/logout')
  async logout(
    @Req() req: FastifyRequest,
    @Res() res: FastifyReply,
  ): Promise<any> {
    const data = await this.authService.logout(req, res);
    res.status(HttpStatus.OK).send(data);
  }

  /**
   * 刷新认证信息
   *
   * @author chitanda
   * @date 2021-09-28 11:09:23
   * @param {FastifyRequest} req
   * @param {FastifyReply} res
   * @return {*}  {Promise<any>}
   */
  @Get('/v7/refreshToken')
  async refreshToken(
    @Req() req: FastifyRequest,
    @Res() res: FastifyReply,
  ): Promise<any> {
    const data = await this.authService.refreshToken(req, res);
    res.status(HttpStatus.OK).send(data);
  }
}
