import { Component, Prop } from 'vue-property-decorator';
import { IPSAppDEGridView } from '@ibiz/dynamic-model-api';
import { ModelTool } from 'ibiz-core';
import { AppDefaultMDViewLayout } from "../app-default-mdview-layout/app-default-mdview-layout";
import './app-default-gridview4-layout.less';

@Component({})
export class AppDefaultGridView4Layout extends AppDefaultMDViewLayout {

    /**
     * 表格视图模型对象
     *
     * @type {IPSAppDEGridView}
     * @memberof AppDefaultGridView4Layout
     */
    @Prop() public declare viewInstance: IPSAppDEGridView;

    /**
     * 绘制内容
     * 
     * @memberof AppDefaultGridView4Layout
     */
    public renderContent() {
        const noHeader = !this.showCaption && !this.viewIsshowToolbar && !this.$slots.quickGroupSearch && !this.$slots.quickSearch
        let cardClass = {
            'view-card': true,
            'mdview-card': true,
            'view-no-caption': !this.showCaption,
            'view-no-toolbar': !this.viewIsshowToolbar,
            'view-no-header': noHeader
        };
        return (
            <card class={cardClass} disHover={true} bordered={false}>
                {!noHeader ? <div slot='title' class='header-container' key='view-header'>
                    {this.renderViewHeader()}
                </div> : null}
                {this.$slots.topMessage}
                {this.viewInstance.enableQuickSearch && !this.viewInstance.expandSearchForm ? null : this.$slots.searchForm}
                <div class='content-container'>
                    {this.$slots.bodyMessage}
                    {this.$slots.mainGrid}
                    {this.$slots.default}
                </div>
                {this.$slots.bottomMessage}
            </card>
        );
    }

}