import { IModal } from '@ibiz-template/runtime';
import { useEditViewController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const EditView = defineComponent({
  props: {
    context: Object as PropType<IContext>,
    params: { type: Object as PropType<IParams> },
    modelPath: { type: String, required: true },
    modal: { type: Object as PropType<IModal> },
    noLoadDefault: { type: Boolean, required: false },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useEditViewController(proxy, props.modelPath);
    return { c };
  },
  render(h) {
    let formComponent = null;
    if (this.c.complete) {
      const { form } = this.c.model;
      if (this.c.providers[form.name]) {
        formComponent = h(this.c.providers[form.name].component, {
          props: {
            modelData: form,
            context: this.c.context,
            params: this.c.params,
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(form.name),
          },
        });
      }
    }

    return <view-base controller={this.c}>{formComponent}</view-base>;
  },
});
