import { FormGroupPanelController } from '@ibiz-template/controller';
import { FormGroupPanelModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { computed, defineComponent, ref, VNode } from 'vue';
import '@ibiz-template/theme/style/components/widgets/form/form-group.scss';

export const FormGroupPanel = defineComponent({
  name: 'FormGroupPanel',
  props: {
    modelData: {
      type: FormGroupPanelModel,
      required: true,
    },
    controller: {
      type: FormGroupPanelController,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('form-group');
    const isCollapse = ref(
      props.modelData.defaultExpansion || props.modelData.disableClose,
    );
    const changeCollapse = () => {
      isCollapse.value = !isCollapse.value;
    };

    const captionText = computed(() => {
      const { captionItemName } = props.modelData;
      if (captionItemName) {
        return props.controller.data[captionItemName];
      }
      return props.modelData.source.caption;
    });

    return { ns, isCollapse, captionText, changeCollapse };
  },
  render() {
    if (!this.controller.visible) {
      return null;
    }
    const defaultSlots: VNode[] = this.$slots.default || [];
    const content = (
      <app-row slot='content' layout={this.modelData.source.getPSLayout()}>
        {defaultSlots.map(slot => {
          if (!slot.componentOptions) {
            return slot;
          }
          const props = (slot.data?.props || {}) as IData;
          return (
            <app-col
              layoutPos={props.modelData.source.getPSLayoutPos()}
              controller={props.controller.layoutController}
            >
              {slot}
            </app-col>
          );
        })}
      </app-row>
    );
    const classArr: string[] = [
      this.ns.b(),
      this.ns.m(this.modelData.modelClass),
    ];
    if (this.modelData.showHeader === true) {
      classArr.push(this.ns.m('show-header'));
      classArr.push(this.ns.b('collapse'));
      if (this.modelData.disableClose) {
        classArr.push(this.ns.bm('collapse', 'disable-close'));
        classArr.push(this.ns.is('collapse', true));
      } else {
        classArr.push(this.ns.is('collapse', this.isCollapse));
      }
    }

    let header: unknown = null;
    if (this.modelData.showHeader) {
      header = (
        <div class={[this.ns.b('header')]}>
          <div class={[this.ns.be('header', 'left')]}>
            <div class={[this.ns.e('caption')]}>{this.captionText}</div>
          </div>
          <div class={[this.ns.be('header', 'right')]}>
            <div class={[this.ns.e('toolbar')]}>{this.$slots.toolbar}</div>
          </div>
          {!this.modelData.disableClose && (
            <div
              class={[this.ns.be('header', 'collapseicon')]}
              onClick={this.changeCollapse}
            >
              <div class={this.ns.bem('header', 'collapseicon', 'tip')}>
                {this.isCollapse ? '收缩' : '展开'}
              </div>
              <i-icon type='ios-arrow-down' />
            </div>
          )}
        </div>
      );
    }
    return (
      <div class={classArr}>
        {header}
        <div class={[this.ns.b('content')]}>{content}</div>
      </div>
    );
  },
});
export default FormGroupPanel;
