import { SpanEditorModel } from '@ibiz-template/model';
import {
  FormItemController,
  GridEditItemController,
  IEditorProvider,
  SpanEditorController,
} from '@ibiz-template/controller';
/**
 * 标签编辑器适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class SpanEditorProvider
 * @implements {EditorProvider}
 */
export class SpanEditorProvider implements IEditorProvider {
  formEditor: string = 'IBizSpan';

  gridEditor: string = 'IBizGridSpan';

  async createController(
    editorModel: SpanEditorModel,
    parentController: FormItemController | GridEditItemController,
  ): Promise<SpanEditorController> {
    const c = new SpanEditorController(editorModel, parentController);
    await c.init();
    return c;
  }
}
