import { ContainerPortletController } from '@ibiz-template/controller';
import { ContainerPortletModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, VNode } from 'vue';

export const PortletContainer = defineComponent({
  name: 'PortletContainer',
  props: {
    modelData: {
      type: ContainerPortletModel,
      required: true,
    },
    controller: {
      type: ContainerPortletController,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('portlet-container');
    return { ns };
  },
  render() {
    const defaultSlots: VNode[] = this.$slots.default || [];
    const content = (
      <app-row layout={this.modelData.source.getPSLayout()}>
        {defaultSlots.map(slot => {
          if (!slot.componentOptions) {
            return slot;
          }
          const props = (slot.componentOptions.propsData || {}) as IData;
          return (
            <app-col
              layoutPos={props.modelData.source.getPSLayoutPos()}
              controller={props.controller.layoutController}
            >
              {slot}
            </app-col>
          );
        })}
      </app-row>
    );
    const classArr: string[] = [
      this.ns.b(),
      this.ns.m(this.modelData.modelClass),
    ];
    let header: unknown = null;
    if (this.modelData.showTitleBar) {
      header = (
        <div class={[this.ns.b('header')]}>
          <div class={[this.ns.e('caption')]}>
            {this.modelData.source.title}
          </div>
        </div>
      );
    }
    return (
      <div class={classArr}>
        {header}
        <div class={[this.ns.b('content')]}>{content}</div>
      </div>
    );
  },
});
