import { IPSDEDataView, IPSAppDataEntity, IPSAppDEField, IPSDESearchForm, IPSDEFormItem, IPSAppDEDataView } from '@ibiz/dynamic-model-api';
import { ModelTool } from 'ibiz-core';
export class AppDataViewModel {

  /**
   * 数据视图实例对象
   * 
   * @memberof AppDataViewModel
   */
  public $DataViewInstance: IPSDEDataView;

  /**
  * Creates an instance of AppGridModel.
  * 
  * @param {*} [opts={}]
  * @memberof AppDataViewModel
  */
  constructor(opts: any) {
    this.$DataViewInstance = opts;
  }

  /**
 * TODO 是否是实体数据导出(暂时未使用)
 *
 * @returns {any}
 * @memberof AppDataViewModel
 */
  public isDEExport: boolean = false;

  /**
 * 获取数据项集合
 *
 * @returns {any[]}
 * @memberof AppDataViewModel
 */
  public getDataItems(): any[] {
    let modelArray: any[] = [
      {
        name: 'size',
        prop: 'size',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'query',
        prop: 'query',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'sort',
        prop: 'sort',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'page',
        prop: 'page',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'srfparentdata',
        prop: 'srfparentdata',
        dataType: 'QUERYPARAM'
      },
      {
        name: 'srfwfmemo',
        prop: 'srfwfmemo',
        dataType: 'TEXT',
      }
    ];
    const appDataEntity = this.$DataViewInstance.getPSAppDataEntity();
    const dataViewItems = this.$DataViewInstance.getPSDEDataViewDataItems() || [];
    //数据项
    if (dataViewItems?.length > 0) {
      dataViewItems.forEach((dataItem: any) => {
        let temp: any = { name: dataItem.name.toLowerCase() };
        if (dataItem.customCode) {
          temp.customCode = true;
          temp.scriptCode = dataItem.scriptCode;
        } else {
          temp.prop = dataItem.getPSAppDEField()?.codeName.toLowerCase();
          temp.dataType = dataItem.getPSAppDEField()?.dataType;
        }
        modelArray.push(temp);
      })
    }
    const searchFormInstance: IPSDESearchForm = ModelTool.findPSControlByType("SEARCHFORM", (this.$DataViewInstance.getParentPSModelObject() as IPSAppDEDataView).getPSControls() || []);
    if (searchFormInstance) {
      (searchFormInstance.getPSDEFormItems?.() || []).forEach((formItem: IPSDEFormItem) => {
        let temp: any = { name: formItem.id, prop: formItem.id };
        if (formItem.getPSAppDEField?.()) {
          temp.dataType = 'QUERYPARAM';
        }
        modelArray.push(temp);
      });
    }
    // 界面主键标识
    modelArray.push({
      name: (appDataEntity as IPSAppDataEntity).codeName.toLowerCase(),
      prop: (ModelTool.getAppEntityKeyField(appDataEntity as IPSAppDataEntity) as IPSAppDEField)?.codeName?.toLowerCase(),
      dataType: 'FRONTKEY',
    })
    return modelArray;
  }
}