import { OrgData } from '@ibiz-template/core';
import { ModelUtil } from '@ibiz-template/model';
import router from '@/router';

/**
 * 初始化模型
 *
 * @author chitanda
 * @date 2022-07-20 20:07:58
 * @return {*}  {Promise<void>}
 */
async function loadModel(): Promise<void> {
  await ModelUtil.create(async modelPath => {
    const url = `${ibiz.env.remoteModelUrl}${modelPath}`;
    try {
      const res = await ibiz.net.get(url);
      if (res.ok) {
        return res.data as IModel;
      }
    } catch (error) {
      console.log(error);
    }
    return {};
  });
}

/**
 * 加载应用数据
 *
 * @author chitanda
 * @date 2022-07-20 20:07:50
 * @return {*}  {Promise<void>}
 */
async function loadAppData(): Promise<void> {
  const res = await ibiz.net.get('/appdata');
  if (res.ok) {
    ibiz.appData = res.data;
  }
}

/**
 * 加载组织数据
 *
 * @author chitanda
 * @date 2022-07-20 20:07:44
 * @return {*}  {Promise<void>}
 */
async function loadOrgData(): Promise<void> {
  const res = await ibiz.net.get(`/uaa/getbydcsystem/${ibiz.env.dcSystem}`);
  if (res.ok) {
    const orgDataItems = res.data as OrgData[];
    if (orgDataItems) {
      const [data] = orgDataItems;
      ibiz.orgData = data;
    }
  }
}

/**
 * 应用参数初始化
 *
 * @author chitanda
 * @date 2022-07-20 19:07:54
 * @return {*}  {Promise<void>}
 */
async function appInit(): Promise<void> {
  try {
    await loadOrgData();
    await loadAppData();
    await loadModel();
  } catch (error) {
    const { response, message } = error as IData;
    if (response.status === 401) {
      router.push('/login');
    }
    console.log(`应用参数初始化失败：${message}`);
  }
}

export async function AuthGuard(): Promise<boolean> {
  await appInit();
  return true;
}
