import { IPSSysImage } from '@ibiz-template/model';
import { computed, defineComponent, PropType } from 'vue';

export const AppIcon = defineComponent({
  name: 'AppIcon',
  props: {
    icon: {
      type: Object as PropType<IPSSysImage>,
    },
    size: {
      type: String as PropType<'small' | 'medium' | 'large'>,
    },
  },
  setup(props) {
    const classNames = computed(() => {
      let className = ' app-icon';
      if (props.size) {
        className += ` app-icon${props.size}`;
      }
      return className;
    });
    const BaseUrl = `${ibiz.env.assetsUrl}/imgs/`;
    return { classNames, BaseUrl };
  },
  render() {
    if (this.icon) {
      if (this.icon.cssClass) {
        return <i class={this.icon.cssClass + this.classNames} />;
      }
      if (this.icon.imagePath) {
        return (
          <img
            class={this.classNames}
            src={this.BaseUrl + this.icon.imagePath}
          />
        );
      }
    }
    return null;
  },
});
export default AppIcon;
