import { defineComponent } from 'vue';
import '@/styles/components/common/app-grid-pagination/app-grid-pagination.scss';
import { useNamespace } from '@ibiz-template/vue-util';

export const AppGridPagination = defineComponent({
  name: 'AppGridPagination',
  props: {
    total: {
      type: Number,
    },
    curPage: {
      type: Number,
    },
    size: {
      type: Number,
    },
  },
  setup() {
    const ns = useNamespace('grid-page');
    return { ns };
  },
  methods: {
    onPageChange(page: number) {
      this.$emit('change', page);
    },
    onPageSizeChange(size: number) {
      this.$emit('page-size-change', size);
    },
    pageReset() {
      this.$emit('page-reset');
    },
  },
  render() {
    return (
      <div class={this.ns.b()}>
        <page
          transfer={true}
          total={this.total}
          show-sizer
          show-elevator
          current={this.curPage}
          page-size={this.size}
          page-size-opts={[10, 20, 30, 40, 50, 60, 70, 80, 90, 100]}
          show-total
          on-on-change={this.onPageChange}
          on-on-page-size-change={this.onPageSizeChange}
        >
          <span class={this.ns.b('btn')}>
            <i-button
              icon='md-refresh'
              title='刷新'
              on-click={this.pageReset}
            ></i-button>
          </span>
          <span>共计&nbsp;{this.total}&nbsp;条数据</span>
        </page>
      </div>
    );
  },
});
export default AppGridPagination;
