import { defineComponent, PropType, reactive } from 'vue';
import { IPSUIActionGroup, IPSUIActionGroupDetail } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import '@/styles/components/common/view-toolbar/view-toolbar.scss';
import { ActionStates, ActionState } from '@ibiz-template/controller';

export const ActionToolbar = defineComponent({
  name: 'ActionToolbar',
  props: {
    actionGroup: {
      type: Object as PropType<IPSUIActionGroup>,
      required: true,
    },
    actionStates: {
      type: Object as PropType<ActionStates>,
      required: true,
    },
  },
  setup(props, { emit }) {
    const ns = useNamespace('action-toolbar');

    // 按钮状态控制
    const actionStates = reactive<{ [p: string]: ActionState }>({});
    props.actionGroup.getPSUIActionGroupDetails()?.forEach(detail => {
      const action = detail.getPSUIAction();
      if (action) {
        actionStates[action.uIActionTag] = { disabled: false };
      }
    });

    // 点击事件抛给表格执行
    const handleClick = async (
      detail: IPSUIActionGroupDetail,
      event: MouseEvent,
    ) => {
      emit('action-click', detail, event);
    };

    return { ns, handleClick };
  },
  render() {
    const details = this.actionGroup.getPSUIActionGroupDetails() || [];
    return (
      <div class={`${this.ns.b()}`}>
        {details.length > 0 &&
          details.map(detail => {
            const action = detail.getPSUIAction();
            if (action) {
              return (
                <i-button
                  type='text'
                  on-click={(e: MouseEvent) => this.handleClick(detail, e)}
                  disabled={this.actionStates[action.uIActionTag].disabled}
                  class={[this.ns.be('item'), this.ns.is('disabled', false)]}
                >
                  {detail.showIcon && action.getPSSysImage() && (
                    <app-icon icon={action.getPSSysImage()}></app-icon>
                  )}
                  {detail.showCaption ? action!.caption : ''}
                </i-button>
              );
            }
            return null;
          })}
      </div>
    );
  },
});
