import { ViewController } from '@ibiz-template/controller';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent, PropType } from 'vue';
import '@ibiz-template/theme/style/components/layout/view-base/view-base.scss';

export const ViewBase = defineComponent({
  props: {
    controller: {
      type: Object as PropType<ViewController>,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('view');

    const renderViewMessage = () => {
      const messageSlots: IData = {};
      if (props.controller.complete) {
        ['TOP', 'BOTTOM', 'BODY'].forEach(position => {
          const viewMessages = props.controller.viewMessages[position];
          if (viewMessages?.length) {
            messageSlots[`${position.toLowerCase()}Message`] = () => {
              return <view-message messages={viewMessages}></view-message>;
            };
          }
        });
      }
      return messageSlots;
    };

    return { ns, renderViewMessage };
  },
  render() {
    const c = this.controller;

    // 外面的插槽同样传给view-layout
    const inheritSlots: IData = {};
    Object.keys(this.$scopedSlots).forEach(key => {
      inheritSlots[key] = (arg: IData) => this.$scopedSlots[key]!(arg);
    });

    return (
      <view-layout
        class={[
          this.ns.b(),
          c.complete && this.ns.b(this.controller.model.typeClass),
          c.complete && this.ns.m(this.controller.model.modelClass),
          c.complete && this.controller.model.sysCssName,
        ]}
        isComplete={c.complete}
        modelData={c.model}
        viewMode={c.modal.mode}
        isLoading={c.viewLoading.isLoading}
        scopedSlots={{
          caption: () => {
            return (
              <div class={this.ns.b('caption')}>
                {c.complete && c.model.source.getPSSysImage() ? (
                  [
                    <app-icon
                      class={this.ns.be('caption', 'icon')}
                      icon={c.model.source.getPSSysImage()}
                    ></app-icon>,
                    <span
                      class={this.ns.be('caption', 'text')}
                      title={c.caption}
                    >
                      {c.caption}
                    </span>,
                  ]
                ) : (
                  <span class={this.ns.be('caption', 'text')} title={c.caption}>
                    {c.caption}
                  </span>
                )}
              </div>
            );
          },
          toolbar: () => {
            if (c.complete && c.model.toolbar) {
              return [
                <view-toolbar
                  modelData={c.model.toolbar}
                  on-neuronInit={c.nerve.onNeuronInit(
                    c.model.toolbar.source.name,
                  )}
                  toolbarState={c.toolbarState}
                  viewMode={c.modal.mode}
                ></view-toolbar>,
              ];
            }
            return null;
          },
          ...this.renderViewMessage(),
          ...inheritSlots,
        }}
      />
    );
  },
});
