import { useNamespace } from '@ibiz-template/vue-util';
import { computed, defineComponent, PropType, ref, watch } from 'vue';
import './exp-view-base.scss';
import { IExpBarModel } from '@ibiz-template/model';
import { ListExpViewController } from '@ibiz-template/controller';

export const ExpViewBase = defineComponent({
  name: 'ExpViewBase',
  props: {
    controller: {
      type: Object as PropType<ListExpViewController>,
      required: true,
    },
    expBarModel: {
      type: Object as PropType<IExpBarModel>,
    },
  },
  setup(props) {
    const ns = useNamespace('exp-view');

    const cssVars = ref({});

    watch(
      () => props.expBarModel?.width,
      (newVal, oldVal) => {
        if (newVal !== oldVal && newVal) {
          cssVars.value = ns.cssVarBlock({
            'left-width': `${newVal}px`,
          });
        }
      },
    );

    // 是否显示头部
    const isShowHeader = computed(() => {
      return (
        (props.expBarModel?.showTitleBar && props.expBarModel?.title) ||
        props.expBarModel?.enableSearch ||
        props.controller.model.toolbar
      );
    });

    return { ns, cssVars, isShowHeader };
  },
  render() {
    const c = this.controller;

    // 外面的插槽同样传给view-layout
    const inheritSlots: IData = {};
    Object.keys(this.$scopedSlots).forEach(key => {
      inheritSlots[key] = (arg: IData) => this.$scopedSlots[key]!(arg);
    });
    return (
      <div class={[this.ns.b()]} style={this.cssVars}>
        <div class={[this.ns.b('left')]}>
          <view-layout
            class={[
              c.complete && this.ns.b(this.controller.model.typeClass),
              c.complete && this.ns.m(this.controller.model.modelClass),
            ]}
            isComplete={c.complete}
            modelData={c.model}
            viewMode={c.modal.mode}
            isLoading={c.viewLoading.isLoading}
            scopedSlots={{
              caption: () => {
                return (
                  <div class={this.ns.b('caption')}>
                    {c.complete && c.model.source.getPSSysImage() ? (
                      [
                        <app-icon
                          class={this.ns.be('caption', 'icon')}
                          icon={c.model.source.getPSSysImage()}
                        ></app-icon>,
                        <span
                          class={this.ns.be('caption', 'text')}
                          title={c.caption}
                        >
                          {c.caption}
                        </span>,
                      ]
                    ) : (
                      <span
                        class={this.ns.be('caption', 'text')}
                        title={c.caption}
                      >
                        {c.caption}
                      </span>
                    )}
                  </div>
                );
              },
              ...inheritSlots,
              default: () => {
                return (
                  <div
                    class={[
                      this.ns.b('exp-bar'),
                      this.ns.is('no-header', !this.isShowHeader),
                    ]}
                  >
                    <div class={this.ns.b('exp-bar-header')}>
                      <div class={this.ns.b('exp-bar-header-left')}>
                        <div
                          class={this.ns.be('exp-bar-header-left', 'caption')}
                        >
                          {this.expBarModel?.showTitleBar &&
                            (this.expBarModel?.getPSSysImage ? (
                              [
                                <app-icon
                                  class={this.ns.be('caption', 'icon')}
                                  icon={this.expBarModel?.getPSSysImage}
                                ></app-icon>,
                                <span
                                  class={this.ns.be('caption', 'text')}
                                  title={this.expBarModel?.title}
                                >
                                  {this.expBarModel?.title}
                                </span>,
                              ]
                            ) : (
                              <span
                                class={this.ns.be('caption', 'text')}
                                title={this.expBarModel?.title}
                              >
                                {this.expBarModel?.title}
                              </span>
                            ))}
                        </div>
                      </div>
                      <div class={this.ns.b('exp-bar-header-right')}>
                        <div class={this.ns.e('quick-search')}>
                          {c.complete && this.expBarModel?.enableSearch && (
                            <quick-search
                              value={c.query}
                              viewMode={c.modal.mode}
                              placeholder={c.model.placeholder}
                              onUpdate={(val: string) => {
                                c.query = val;
                              }}
                              onSearch={() => c.onSearch()}
                            ></quick-search>
                          )}
                        </div>
                        <div class={this.ns.e('toolbar')}>
                          {c.complete && c.model.toolbar && (
                            <view-toolbar
                              modelData={c.model.toolbar}
                              on-neuronInit={c.nerve.onNeuronInit(
                                c.model.toolbar.source.name,
                              )}
                              toolbarState={c.toolbarState}
                              viewMode={c.modal.mode}
                            ></view-toolbar>
                          )}
                        </div>
                      </div>
                    </div>
                    <div class={this.ns.b('exp-bar-content')}>
                      {inheritSlots.default && inheritSlots.default()}
                    </div>
                  </div>
                );
              },
            }}
          ></view-layout>
        </div>
        <div class={[this.ns.b('right')]}>
          {this.$scopedSlots.expView && this.$scopedSlots.expView({})}
        </div>
      </div>
    );
  },
});
