import { defineComponent } from 'vue';
import { getGridSpanProps, useNamespace } from '@ibiz-template/vue-util';

export const IBizGridSpan = defineComponent({
  name: 'IBizGridSpan',
  props: getGridSpanProps(),
  setup() {
    const ns = useNamespace('grid-span');
    return { ns };
  },
  render(h) {
    return (
      <div
        class={`${this.ns.b()} ibiz-grid-editor`}
        onDblclick={evt => evt.stopPropagation()}
        onClick={evt => evt.stopPropagation()}
      >
        {h('IBizSpan', {
          props: {
            ...this.$props,
          },
        })}
      </div>
    );
  },
});
