/* eslint-disable no-param-reassign */
import { defineComponent, PropType, watch, Ref, ref } from 'vue';
import { useNamespace } from '@ibiz-template/vue-util';
import dayjs from 'dayjs';
import { clone } from 'ramda';
import '@ibiz-template/theme/style/components/common/extend-action-grid/extend-action-grid.scss';

/**
 * 办理人员名称显示去重
 *
 * @param tag 需要去重的名称标识
 * @param dataS 需要去重数据集
 */
const acceptingOfficerNoDup = (tag: string, dataS: IData[]) => {
  const tempData: IData[] = [];
  if (dataS?.length > 0 && tag) {
    dataS.forEach((data: IData) => {
      tempData.push(data[tag]);
    });
  }
  const noDup = [...new Set(tempData)];
  return noDup;
};

/**
 * 绘制人员
 */
const renderAuthorName = (task: IData) => {
  let authorNames: IData[] = [];
  if (task.comments.length > 0) {
    authorNames = acceptingOfficerNoDup('authorName', task.comments);
  } else {
    authorNames = acceptingOfficerNoDup('displayname', task.identitylinks);
  }
  const disabled = !(authorNames.length > 1);
  const content = authorNames.map(item => item).toString();
  return (
    <i-tooltip
      placement='bottom'
      content={content}
      theme='light'
      disabled={disabled}
    >
      {content}
    </i-tooltip>
  );
};

/**
 * 绘制单位
 */
const renderAuthorOrgName = (task: IData) => {
  let authorOrgNames: IData[] = [];
  if (task.comments.length > 0) {
    authorOrgNames = acceptingOfficerNoDup('authorOrgName', task.comments);
  }
  const disabled = !(authorOrgNames.length > 1);
  const content = authorOrgNames.map(item => item).toString();
  return (
    <i-tooltip
      placement='bottom'
      content={content}
      theme='light'
      disabled={disabled}
    >
      {content}
    </i-tooltip>
  );
};

/**
 * 绘制部门
 */
const renderAuthorDeptName = (task: IData) => {
  let authorDeptNames: IData[] = [];
  if (task.comments.length > 0) {
    authorDeptNames = acceptingOfficerNoDup('authorDeptName', task.comments);
  }
  const disabled = !(authorDeptNames.length > 1);
  const content = authorDeptNames.map(item => item).toString();
  return (
    <i-tooltip
      placement='bottom'
      content={content}
      theme='light'
      disabled={disabled}
    >
      {content}
    </i-tooltip>
  );
};

export const ExtendActionGrid = defineComponent({
  name: 'ExtendActionGrid',
  props: {
    data: {
      type: Object as PropType<IData>,
    },
  },
  setup(props) {
    const ns = useNamespace('extend-action-grid');

    const UIData: Ref<IData | null> = ref(null);

    watch(
      () => props.data,
      (newVal, oldVal) => {
        if (newVal !== oldVal && newVal) {
          const copyData = clone(newVal);
          if (copyData.usertasks.length > 0) {
            copyData.usertasks.forEach((task: IData) => {
              task.isShow = false;
            });
            copyData.usertasks = copyData.usertasks.reverse();
            UIData.value = copyData;
          }
        }
      },
      { immediate: true },
    );

    /**
     * 时间转换
     *
     *  @memberof ExtendActionTimeline
     */
    const formatDate = (date: string, format: string) => {
      return dayjs(date).format(format);
    };

    /**
     * 点击事件
     *
     *  @memberof ExtendActionTimeline
     */
    const changeExpand = (userTask: IData) => {
      userTask.isShow = !userTask.isShow;
    };

    return { ns, formatDate, changeExpand, UIData };
  },
  render() {
    return (
      <div class={this.ns.b()}>
        <div class={this.ns.b('header')}>
          <div class={this.ns.be('header', 'index')}>序号</div>
          <div class={this.ns.be('header', 'user-task-name')}>节点</div>
          <div class={this.ns.be('header', 'author-name')}>办理人员</div>
          <div class={this.ns.be('header', 'author-org-name')}>单位</div>
          <div class={this.ns.be('header', 'author-dept-name')}>部门</div>
          <div class={this.ns.be('header', 'type')}>操作</div>
          <div class={this.ns.be('header', 'last-time')}>完成时间</div>
          <div class={this.ns.be('header', 'full-message')}>审批意见</div>
        </div>
        <div class={this.ns.b('content')}>
          {this.UIData &&
            this.UIData.usertasks.map((task: IData, index: number) => {
              return [
                <div class={this.ns.b('task')}>
                  <div class={this.ns.be('task', 'index')}>
                    <span>{index + 1}</span>
                  </div>
                  <div class={this.ns.be('task', 'user-task-name')}>
                    <i-tooltip
                      placement='bottom'
                      content={task.userTaskName}
                      theme='light'
                    >
                      {task.userTaskName}
                    </i-tooltip>
                  </div>
                  <div class={this.ns.be('task', 'author-name')}>
                    {renderAuthorName(task)}
                  </div>
                  <div class={this.ns.be('task', 'author-org-name')}>
                    {renderAuthorOrgName(task)}
                  </div>
                  <div class={this.ns.be('task', 'author-dept-name')}>
                    {renderAuthorDeptName(task)}
                  </div>
                  <div class={this.ns.be('task', 'type')}>
                    {task.comments[task.comments.length - 1] &&
                      task.comments[task.comments.length - 1].type}
                  </div>
                  <div class={this.ns.be('task', 'last-time')}>
                    {task.comments[task.comments.length - 1] &&
                      this.formatDate(
                        task.comments[task.comments.length - 1].time,
                        'MM月DD日 HH:mm:ss',
                      )}
                  </div>
                  <div class={this.ns.be('task', 'full-message')}>
                    {task.comments[task.comments.length - 1] &&
                      task.comments[task.comments.length - 1].fullMessage}
                  </div>
                  {(task.comments.length > 1 ||
                    task.identitylinks.length > 1) && (
                    <div
                      class={this.ns.be('task', 'arrow')}
                      on-click={() => {
                        this.changeExpand(task);
                      }}
                    >
                      <i-icon type={task.isShow ? 'md-remove' : 'md-add'} />
                    </div>
                  )}
                </div>,
                task.isShow && [
                  task.comments.map((comment: IData) => {
                    return (
                      <div class={this.ns.b('comment')}>
                        <div class={this.ns.be('comment', 'index')}></div>
                        <div
                          class={this.ns.be('comment', 'user-task-name')}
                        ></div>
                        <div class={this.ns.be('comment', 'author-name')}>
                          {comment.authorName}
                        </div>
                        <div class={this.ns.be('comment', 'author-org-name')}>
                          {comment.authorOrgName}
                        </div>
                        <div class={this.ns.be('comment', 'author-dept-name')}>
                          {comment.authorDeptName}
                        </div>
                        <div class={this.ns.be('comment', 'type')}>
                          {comment.type}
                        </div>
                        <div class={this.ns.be('comment', 'last-time')}>
                          {this.formatDate(comment.time, 'MM月DD日 HH:mm:ss')}
                        </div>
                        <div class={this.ns.be('comment', 'full-message')}>
                          {comment.fullMessage}
                        </div>
                      </div>
                    );
                  }),
                  task.identitylinks.length > 0 && (
                    <div class={this.ns.b('identity-link')}>
                      <div class={this.ns.be('identity-link', 'index')}></div>
                      <div
                        class={this.ns.be('identity-link', 'user-task-name')}
                      >
                        <i-tooltip
                          placement='bottom'
                          content='待办理'
                          theme='light'
                        >
                          待办理
                        </i-tooltip>
                      </div>
                      <div class={this.ns.be('identity-link', 'author-name')}>
                        <i-tooltip
                          placement='bottom'
                          content={task.identitylinks
                            .map((item: IData) => item.displayname)
                            .toString()}
                          theme='light'
                        >
                          {task.identitylinks
                            .map((item: IData) => item.displayname)
                            .toString()}
                        </i-tooltip>
                      </div>
                    </div>
                  ),
                ],
              ];
            })}
        </div>
      </div>
    );
  },
});
