import {
  GridUAColumnController,
  GridRowController,
} from '@ibiz-template/controller';
import { IPSUIActionGroupDetail } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { computed, defineComponent } from 'vue';
import '@ibiz-template/theme/style/components/widgets/grid/grid-ua-column.scss';

export const GridUAColumn = defineComponent({
  name: 'GridUAColumn',
  props: {
    controller: {
      type: GridUAColumnController,
      required: true,
    },
    row: {
      type: GridRowController,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('grid-ua-column');
    const onStopPropagation = (e: MouseEvent) => {
      e.stopPropagation();
    };
    const onActionClick = async (
      detail: IPSUIActionGroupDetail,
      event: MouseEvent,
    ) => {
      await props.controller.onActionClick(detail, props.row, event);
    };

    // 操作列对齐方式样式变量
    const alignStyle = computed(() => {
      let justContent = '';
      switch (props.controller.model.align) {
        case 'LEFT':
          justContent = 'flex-start';
          break;
        case 'RIGHT':
          justContent = 'flex-end';
          break;
        default:
          justContent = 'center';
          break;
      }
      return ns.cssVarBlock({ 'justify-content': justContent });
    });

    return { ns, alignStyle, onStopPropagation, onActionClick };
  },
  render() {
    return (
      <div
        class={this.ns.b()}
        style={this.alignStyle}
        on-dblclick={this.onStopPropagation}
        onClick={this.onStopPropagation}
      >
        {!this.controller.model.actionGroup ? null : (
          <actionToolbar
            action-group={this.controller.model.actionGroup}
            actions-state={
              this.row.uaColumnStates[this.controller.model.codeName]
            }
            on-action-click={this.onActionClick}
          ></actionToolbar>
        )}
      </div>
    );
  },
});
export default GridUAColumn;
