import { ListNeuron, ListPortletController } from '@ibiz-template/controller';
import { ListPortletModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent } from 'vue';

export const ListPortlet = defineComponent({
  name: 'ListPortlet',
  props: {
    modelData: {
      type: ListPortletModel,
      required: true,
    },
    controller: {
      type: ListPortletController,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('list-portlet');
    return { ns };
  },
  render(h) {
    const c = this.controller;
    let listComponent = null;
    const { list } = c.model;
    if (c.listProvider) {
      listComponent = h(c.listProvider.component, {
        props: {
          modelData: list,
          context: c.context,
          params: c.params,
        },
        on: {
          neuronInit: (neuron: ListNeuron) => {
            c.setListNeuron(neuron);
          },
        },
      });
    }

    const classArr: string[] = [
      this.ns.b(),
      this.ns.m(this.modelData.modelClass),
    ];
    return (
      <portlet-layout controller={this.controller} class={classArr}>
        {listComponent}
      </portlet-layout>
    );
  },
});
