import { EntityProxyMiddleware } from '../../core';
import { MiddlewareConsumer, Module, NestModule } from '@nestjs/common';
import { ReginfoController } from './reginfo.controller';

export class ReginfoMiddleware extends EntityProxyMiddleware {
  protected serviceTag = 'reginfo';
}

@Module({
  controllers: [ReginfoController]
})
export class ReginfoModule implements NestModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(ReginfoMiddleware).forRoutes('(.*)/importdata', '(.*)/importtemplate', '(.*)/exportdata/(.*)');
  }
}

