import { defineComponent } from 'vue';
import {
  getGridRadioProps,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';

export const IBizGridRadio = defineComponent({
  name: 'IBizGridRadio',
  props: getGridRadioProps(),
  setup(props) {
    const ns = useNamespace('grid-radio');
    const { isInfoMode, componentRef, onOperateChange, onChange } =
      useGridCellEditor(props.rowDataChange, props.rowSave, {
        isDelaySave: false,
      });

    return {
      ns,
      isInfoMode,
      componentRef,
      onOperateChange,
      onChange,
    };
  },
  render(h) {
    return (
      <grid-editor
        disabled={this.disabled}
        readonly={this.readonly}
        ref='componentRef'
        class={`${this.ns.b()}`}
      >
        {h('IBizRadio', {
          props: {
            ...this.$props,
            readonly: this.readonly || this.isInfoMode,
            disabled: this.disabled,
          },
          on: {
            change: this.onChange,
            operate: this.onOperateChange,
          },
        })}
      </grid-editor>
    );
  },
});
