import { presetControlProvider } from './control';
import { presetEditorProvider } from './editor';
import { presetFormDetailProvider } from './form-detail';
import { presetGridColumnProvider } from './grid-column';
import { presetPortletPartProvider } from './portlet-part';
import { presetViewProvider } from './view';

export * from './editor';
export * from './form-detail';
export * from './grid-column';
export * from './portlet-part';
export * from './control';

/**
 * 注册所有预置的适配器
 *
 * @author lxm
 * @date 2022-10-17 18:10:30
 * @export
 */
export function presetAllProviders(): void {
  presetEditorProvider();
  presetFormDetailProvider();
  presetPortletPartProvider();
  presetControlProvider();
  presetViewProvider();
  presetGridColumnProvider();
}
