import { FormItemModel } from '@ibiz-template/model';
import {
  FormContainerController,
  FormController,
  FormItemController,
  IFormDetailProvider,
} from '@ibiz-template/controller';
/**
 * 表单项适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class FormItemProvider
 * @implements {EditorProvider}
 */
export class FormItemProvider
  implements IFormDetailProvider<FormItemController>
{
  compName: string = 'FormItem';

  async createController(
    detailModel: FormItemModel,
    form: FormController,
    parent: FormContainerController | undefined,
  ): Promise<FormItemController> {
    const c = new FormItemController(detailModel, form, parent);
    await c.init();
    return c;
  }
}
