import { FormButtonModel } from '@ibiz-template/model';
import {
  FormContainerController,
  FormController,
  FormButtonController,
  IFormDetailProvider,
} from '@ibiz-template/controller';
/**
 * 表单按钮适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class FormButtonProvider
 * @implements {EditorProvider}
 */
export class FormButtonProvider
  implements IFormDetailProvider<FormButtonController>
{
  compName: string = 'FormButton';

  async createController(
    detailModel: FormButtonModel,
    form: FormController,
    parent: FormContainerController | undefined,
  ): Promise<FormButtonController> {
    const c = new FormButtonController(detailModel, form, parent);
    await c.init();
    return c;
  }
}
