import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent } from 'vue';
import '@ibiz-template/theme/style/components/widgets/grid/grid-editor.scss';

export const GridEditor = defineComponent({
  name: 'GridEditor',
  props: {
    disabled: {
      type: Boolean,
    },
  },
  setup() {
    const ns = useNamespace('grid-editor');
    return { ns };
  },
  render() {
    return (
      <div
        class={[this.ns.b(), !this.disabled ? this.ns.m('editable') : '']}
        onDblclick={evt => evt.stopPropagation()}
        onClick={evt => evt.stopPropagation()}
      >
        {this.$slots.default}
      </div>
    );
  },
});
export default GridEditor;
