import { Module } from '@nestjs/common';
import { PassportModule } from '@nestjs/passport';
import { JwtModule } from '@nestjs/jwt';
import { APP_GUARD } from '@nestjs/core';
import { ConfigModule } from '@nestjs/config';
import { AuthController } from './auth.controller';
import { JwtStrategy } from './jwt.strategy';
import { JwtAuthGuard } from './jwt-auth.guard';
import { AuthService } from './auth.service';
import { CachingModule } from '../caching/caching.module';
import { jwtConstants } from '@/core/constants';

/**
 * 认证模块
 *
 * @author chitanda
 * @date 2021-08-17 20:08:55
 * @export
 * @class AuthModule
 */
@Module({
  imports: [
    PassportModule.register({ defaultStrategy: 'jwt' }),
    JwtModule.register({
      secret: jwtConstants.secret,
      publicKey: jwtConstants.publicKey,
      signOptions: { expiresIn: '60s' },
    }),
    ConfigModule,
    CachingModule,
  ],
  controllers: [AuthController],
  providers: [
    JwtStrategy,
    {
      provide: APP_GUARD,
      useClass: JwtAuthGuard,
    },
    AuthService,
  ],
  exports: [
    AuthService
  ]
})
export class AuthModule { }
