import { MiddlewareConsumer, Module, NestModule } from '@nestjs/common';
import { ProxyMiddleware } from '../../middleware';

export class IBizUtilProxyMiddleware extends ProxyMiddleware {
  protected serviceTag = 'ou';
}

/**
 * 高速缓存模块
 *
 * @author chitanda
 * @date 2021-08-18 21:08:12
 * @export
 * @class IBizConfigModule
 */
@Module({})
export class IBizOUModule implements NestModule {
  configure(consumer: MiddlewareConsumer) {
    consumer.apply(IBizUtilProxyMiddleware).forRoutes('sysorganizations');
  }
}
