import {
  ContainerPortletController,
  DashboardController,
  IPortletPartProvider,
  RawItemPortletController,
} from '@ibiz-template/controller';
import { PortletPartModel, RawItemPortletModel } from '@ibiz-template/model';

/**
 * 数据看板成员直接内容适配器
 *
 * @author lxm
 * @date 2022-10-19 15:10:44
 * @export
 * @class RawItemPortletProvider
 */
export class RawItemPortletProvider implements IPortletPartProvider {
  compName: string = 'PortletPart';

  async createController(
    portletModel: PortletPartModel,
    dashboard: DashboardController,
    parent?: ContainerPortletController,
  ): Promise<RawItemPortletController> {
    const c = new RawItemPortletController(
      portletModel as RawItemPortletModel,
      dashboard,
      parent,
    );
    await c.init();
    return c;
  }
}
