import {
  ActionBarPortletController,
  ContainerPortletController,
  DashboardController,
  IPortletPartProvider,
} from '@ibiz-template/controller';
import { ActionBarPortletModel, PortletPartModel } from '@ibiz-template/model';

/**
 * 数据看板成员操作栏适配器
 *
 * @author lxm
 * @date 2022-10-19 15:10:44
 * @export
 * @class ActionBarPortletProvider
 */
export class ActionBarPortletProvider implements IPortletPartProvider {
  compName: string = 'PortletPart';

  async createController(
    portletModel: PortletPartModel,
    dashboard: DashboardController,
    parent?: ContainerPortletController,
  ): Promise<ActionBarPortletController> {
    const c = new ActionBarPortletController(
      portletModel as ActionBarPortletModel,
      dashboard,
      parent,
    );
    await c.init();
    return c;
  }
}
