import { ViewMode } from '@ibiz-template/runtime';
import { ViewPortletModel } from '@ibiz-template/model';
import { defineComponent, h } from 'vue';
import './view-portlet.scss';
import { useNamespace } from '@ibiz-template/vue-util';
import { ViewNeuron, ViewPortletController } from '@ibiz-template/controller';

export const ViewPortlet = defineComponent({
  name: 'ViewPortlet',
  props: {
    modelData: {
      type: ViewPortletModel,
      required: true,
    },
    controller: {
      type: ViewPortletController,
      required: true,
    },
  },
  setup(props) {
    const ns = useNamespace('view-portlet');

    const onNeuronInit = (n: ViewNeuron) => {
      props.controller.setViewNeuron(n);
    };
    return { ns, onNeuronInit };
  },
  render() {
    const c = this.controller;
    const classArr: string[] = [
      this.ns.b(),
      this.ns.m(this.modelData.modelClass),
    ];
    return (
      <portlet-layout controller={this.controller} class={classArr}>
        {h('ViewShell', {
          attrs: {
            context: c.viewContext,
            params: c.params,
            modal: { mode: ViewMode.EMBED },
            modelPath: c.model.embedView.source.modelPath,
          },
          on: {
            neuronInit: this.onNeuronInit,
          },
          key: c.model.embedView.codeName,
        })}
      </portlet-layout>
    );
  },
});
