import { ReginfoUIServiceBase } from './reginfo-ui-service-base';

/**
 * 学员登记信息UI服务对象
 *
 * @export
 * @class ReginfoUIService
 */
export default class ReginfoUIService extends ReginfoUIServiceBase {

    /**
     * 基础UI服务实例
     * 
     * @private
     * @type {ORDER1UIServiceBase}
     * @memberof ReginfoUIService
     */
    private static basicUIServiceInstance: ReginfoUIService;

    /**
     * 动态模型服务存储Map对象
     *
     * @private
     * @type {Map<string, any>}
     * @memberof ReginfoUIService
     */
    private static UIServiceMap: Map<string, any> = new Map();

    /**
     * Creates an instance of  ReginfoUIService.
     * 
     * @param {*} [opts={}]
     * @memberof  ReginfoUIService
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 通过应用上下文获取实例对象
     *
     * @public
     * @memberof ReginfoUIService
     */
    public static getInstance(context: any): ReginfoUIService {
        if (!this.basicUIServiceInstance) {
            this.basicUIServiceInstance = new ReginfoUIService({context:context});
        }
        if (!context.srfdynainstid) {
            return this.basicUIServiceInstance;
        } else {
            if (!ReginfoUIService.UIServiceMap.get(context.srfdynainstid)) {
                ReginfoUIService.UIServiceMap.set(context.srfdynainstid, new ReginfoUIService({context:context}));
            }
            return ReginfoUIService.UIServiceMap.get(context.srfdynainstid);
        }
    }

}