import { EntityBase } from 'ibiz-core';
import { IBook } from '../interface';

/**
 * 书基类
 *
 * @export
 * @abstract
 * @class BookBase
 * @extends {EntityBase}
 * @implements {IBook}
 */
export abstract class BookBase extends EntityBase implements IBook {
    /**
     * 实体名称
     *
     * @readonly
     * @type {string}
     * @memberof BookBase
     */
    get srfdename(): string {
        return 'BOOK';
    }
    get srfkey() {
        return this.bookid;
    }
    set srfkey(val: any) {
        this.bookid = val;
    }
    get srfmajortext() {
        return this.bookname;
    }
    set srfmajortext(val: any) {
        this.bookname = val;
    }
    /**
     * 书名称
     */
    bookname?: any;
    /**
     * 建立人
     */
    createman?: any;
    /**
     * 建立时间
     */
    createdate?: any;
    /**
     * 更新人
     */
    updateman?: any;
    /**
     * 更新时间
     */
    updatedate?: any;
    /**
     * 书标识
     */
    bookid?: any;
    /**
     * 组织机构标识
     */
    orgid?: any;
    /**
     * 组织部门标识
     */
    deptid?: any;
    /**
     * 类型
     */
    type?: any;

    /**
     * 重置实体数据
     *
     * @private
     * @param {*} [data={}]
     * @memberof BookBase
     */
    reset(data: any = {}): void {
        super.reset(data);
        this.bookid = data.bookid || data.srfkey;
        this.bookname = data.bookname || data.srfmajortext;
    }
}
