import { EntityBase } from 'ibiz-core';
import { IReginfo } from '../interface';

/**
 * 学员登记信息基类
 *
 * @export
 * @abstract
 * @class ReginfoBase
 * @extends {EntityBase}
 * @implements {IReginfo}
 */
export abstract class ReginfoBase extends EntityBase implements IReginfo {
    /**
     * 实体名称
     *
     * @readonly
     * @type {string}
     * @memberof ReginfoBase
     */
    get srfdename(): string {
        return 'REGINFO';
    }
    get srfkey() {
        return this.reginfoid;
    }
    set srfkey(val: any) {
        this.reginfoid = val;
    }
    get srfmajortext() {
        return this.reginfoname;
    }
    set srfmajortext(val: any) {
        this.reginfoname = val;
    }
    /**
     * 更新时间
     */
    updatedate?: any;
    /**
     * 建立时间
     */
    createdate?: any;
    /**
     * 更新人
     */
    updateman?: any;
    /**
     * 建立人
     */
    createman?: any;
    /**
     * 学员登记信息名称
     */
    reginfoname?: any;
    /**
     * 学员登记信息标识
     */
    reginfoid?: any;
    /**
     * 组织机构标识
     */
    orgid?: any;
    /**
     * 组织部门标识
     */
    deptid?: any;
    /**
     * 学员编号
     */
    stuno?: any;
    /**
     * 属性
     */
    field?: any;
    /**
     * 学员姓名
     */
    name?: any;
    /**
     * 单位
     */
    department?: any;
    /**
     * 年龄
     */
    age?: any;
    /**
     * 家庭住址
     */
    address?: any;

    /**
     * 重置实体数据
     *
     * @private
     * @param {*} [data={}]
     * @memberof ReginfoBase
     */
    reset(data: any = {}): void {
        super.reset(data);
        this.reginfoid = data.reginfoid || data.srfkey;
        this.reginfoname = data.reginfoname || data.srfmajortext;
    }
}
