import { ReginfoAuthServiceBase } from './reginfo-auth-service-base';


/**
 * 学员登记信息权限服务对象
 *
 * @export
 * @class ReginfoAuthService
 * @extends {ReginfoAuthServiceBase}
 */
export default class ReginfoAuthService extends ReginfoAuthServiceBase {

    /**
     * 基础权限服务实例
     * 
     * @private
     * @type {ReginfoAuthService}
     * @memberof ReginfoAuthService
     */
    private static basicUIServiceInstance: ReginfoAuthService;

     /**
      * 动态模型服务存储Map对象
      *
      * @private
      * @type {Map<string, any>}
      * @memberof ReginfoAuthService
      */
    private static AuthServiceMap: Map<string, any> = new Map();

    /**
     * Creates an instance of  ReginfoAuthService.
     * 
     * @param {*} [opts={}]
     * @memberof  ReginfoAuthService
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 通过应用上下文获取实例对象
     *
     * @public
     * @memberof ReginfoAuthService
     */
     public static getInstance(context: any): ReginfoAuthService {
        if (!this.basicUIServiceInstance) {
            this.basicUIServiceInstance = new ReginfoAuthService({context:context});
        }
        if (!context.srfdynainstid) {
            return this.basicUIServiceInstance;
        } else {
            if (!ReginfoAuthService.AuthServiceMap.get(context.srfdynainstid)) {
                ReginfoAuthService.AuthServiceMap.set(context.srfdynainstid, new ReginfoAuthService({context:context}));
            }
            return ReginfoAuthService.AuthServiceMap.get(context.srfdynainstid);
        }
    }


}