import { PhoneAuthServiceBase } from './phone-auth-service-base';


/**
 * 手机权限服务对象
 *
 * @export
 * @class PhoneAuthService
 * @extends {PhoneAuthServiceBase}
 */
export default class PhoneAuthService extends PhoneAuthServiceBase {

    /**
     * 基础权限服务实例
     * 
     * @private
     * @type {PhoneAuthService}
     * @memberof PhoneAuthService
     */
    private static basicUIServiceInstance: PhoneAuthService;

     /**
      * 动态模型服务存储Map对象
      *
      * @private
      * @type {Map<string, any>}
      * @memberof PhoneAuthService
      */
    private static AuthServiceMap: Map<string, any> = new Map();

    /**
     * Creates an instance of  PhoneAuthService.
     * 
     * @param {*} [opts={}]
     * @memberof  PhoneAuthService
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 通过应用上下文获取实例对象
     *
     * @public
     * @memberof PhoneAuthService
     */
     public static getInstance(context: any): PhoneAuthService {
        if (!this.basicUIServiceInstance) {
            this.basicUIServiceInstance = new PhoneAuthService({context:context});
        }
        if (!context.srfdynainstid) {
            return this.basicUIServiceInstance;
        } else {
            if (!PhoneAuthService.AuthServiceMap.get(context.srfdynainstid)) {
                PhoneAuthService.AuthServiceMap.set(context.srfdynainstid, new PhoneAuthService({context:context}));
            }
            return PhoneAuthService.AuthServiceMap.get(context.srfdynainstid);
        }
    }


}