import { BookAuthServiceBase } from './book-auth-service-base';


/**
 * 书权限服务对象
 *
 * @export
 * @class BookAuthService
 * @extends {BookAuthServiceBase}
 */
export default class BookAuthService extends BookAuthServiceBase {

    /**
     * 基础权限服务实例
     * 
     * @private
     * @type {BookAuthService}
     * @memberof BookAuthService
     */
    private static basicUIServiceInstance: BookAuthService;

     /**
      * 动态模型服务存储Map对象
      *
      * @private
      * @type {Map<string, any>}
      * @memberof BookAuthService
      */
    private static AuthServiceMap: Map<string, any> = new Map();

    /**
     * Creates an instance of  BookAuthService.
     * 
     * @param {*} [opts={}]
     * @memberof  BookAuthService
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 通过应用上下文获取实例对象
     *
     * @public
     * @memberof BookAuthService
     */
     public static getInstance(context: any): BookAuthService {
        if (!this.basicUIServiceInstance) {
            this.basicUIServiceInstance = new BookAuthService({context:context});
        }
        if (!context.srfdynainstid) {
            return this.basicUIServiceInstance;
        } else {
            if (!BookAuthService.AuthServiceMap.get(context.srfdynainstid)) {
                BookAuthService.AuthServiceMap.set(context.srfdynainstid, new BookAuthService({context:context}));
            }
            return BookAuthService.AuthServiceMap.get(context.srfdynainstid);
        }
    }


}