import { Vue, Component, Prop, Inject } from 'vue-property-decorator';
import { VueLifeCycleProcessing } from '../../../decorators';
import { EditorBase } from '../editor-base/editor-base';

/**
 * 开关控件编辑器
 *
 * @export
 * @class SwitchEditor
 * @extends {EditorBase}
 */
@Component({})
@VueLifeCycleProcessing()
export default class SwitchEditor extends EditorBase {

    /**
     * 绘制内容
     *
     * @returns {*}
     * @memberof SwitchEditor
     */
    public render(): any {
        return this.$createElement(this.editorComponentName,{
            props: {
                name: this.editorInstance.name,
                value: this.value,
                disabled: this.disabled,
                ...this.customProps,
            },
            on: { 
              change: this.editorChange,
              enter: this.editorEnter,
              leave: this.editorLeave              
            },
            class:this.dynaClass,
            style: this.customStyle
        })
    }
}
