import { IBizContext } from '@ibiz-template/core';
import { EditFormModel } from '@ibiz-template/model';
import { useEditFormController } from '@ibiz-template/vue-util';
import { defineComponent, getCurrentInstance, PropType } from 'vue';

export const EditFormControl = defineComponent({
  name: 'EditFormControl',
  props: {
    modelData: {
      type: EditFormModel,
      required: true,
    },
    context: {
      type: IBizContext,
      required: true,
    },
    params: { type: Object as PropType<IParams>, default: () => ({}) },
  },
  setup(props) {
    const { proxy } = getCurrentInstance()!;
    const c = useEditFormController(
      proxy,
      props.modelData,
      props.context,
      props.params,
    );
    return { c };
  },

  render() {
    return !this.c.complete ? null : (
      <form-control
        model-data={this.modelData}
        context={this.context}
        controller={this.c}
      ></form-control>
    );
  },
});
