import {
  GridEditItemController,
  GridFieldColumnController,
  GridRowController,
} from '@ibiz-template/controller';
import { computed, defineComponent } from 'vue';

export const GridColumn = defineComponent({
  name: 'GridColumn',
  props: {
    fieldColumn: {
      type: GridFieldColumnController,
      required: true,
    },
    editItem: {
      type: GridEditItemController,
    },
    row: {
      type: GridRowController,
      required: true,
    },
  },
  setup(props) {
    /** 先看列是否启用行编辑，然后是否有配置编辑项 */
    const renderRowEdit = computed(() => {
      return props.fieldColumn.enableRowEdit && props.editItem;
    });
    return { renderRowEdit };
  },
  render() {
    if (this.renderRowEdit) {
      return (
        <grid-edit-item
          controller={this.editItem}
          row={this.row}
        ></grid-edit-item>
      );
    }
    return (
      <grid-field-column
        controller={this.fieldColumn}
        row={this.row}
      ></grid-field-column>
    );
  },
});
export default GridColumn;
