import { FormTabPageModel } from '@ibiz-template/model';
import {
  FormContainerController,
  FormController,
  FormTabPageController,
  IFormDetailProvider,
} from '@ibiz-template/controller';
/**
 * 表单分页面板适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class FormTabPageProvider
 * @implements {EditorProvider}
 */
export class FormTabPageProvider implements IFormDetailProvider {
  component: string = 'FormTabPage';

  async createController(
    detailModel: FormTabPageModel,
    form: FormController,
    parent: FormContainerController | undefined,
  ): Promise<FormTabPageController> {
    const c = new FormTabPageController(detailModel, form, parent);
    await c.init();
    return c;
  }
}
