import { FormPageModel } from '@ibiz-template/model';
import {
  FormContainerController,
  FormController,
  FormPageController,
  IFormDetailProvider,
} from '@ibiz-template/controller';
/**
 * 表单分页部件适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class FormPageProvider
 * @implements {EditorProvider}
 */
export class FormPageProvider implements IFormDetailProvider {
  component: string = 'FormPage';

  async createController(
    detailModel: FormPageModel,
    form: FormController,
    _parent: FormContainerController | undefined,
  ): Promise<FormPageController> {
    const c = new FormPageController(detailModel, form);
    await c.init();
    return c;
  }
}
