import { PortletPartController } from '@ibiz-template/controller';
import { PortletPartModel } from '@ibiz-template/model';
import { useNamespace } from '@ibiz-template/vue-util';
import { defineComponent } from 'vue';

export const PortletPart = defineComponent({
  name: 'PortletPart',
  props: {
    modelData: {
      type: PortletPartModel,
      required: true,
    },
    controller: {
      type: PortletPartController,
      required: true,
    },
  },
  setup() {
    const ns = useNamespace('portlet-part');
    return { ns };
  },
  render() {
    const classArr: string[] = [
      this.ns.b(),
      this.ns.m(this.modelData.modelClass),
    ];
    return (
      <portlet-layout controller={this.controller} class={classArr}>
        {this.modelData.source.portletType}暂未支持
      </portlet-layout>
    );
  },
});
