var ce = Object.defineProperty;
var de = (e, t, s) => t in e ? ce(e, t, { enumerable: !0, configurable: !0, writable: !0, value: s }) : e[t] = s;
var E = (e, t, s) => (de(e, typeof t != "symbol" ? t + "" : t, s), s);
import { IndexViewModel as ue, GridModel as he, ViewType as me, ModelUtil as pe } from "@ibiz-template/model";
import { GridFieldColumnController as Z, GridRowController as X, WFStepTraceViewController as fe, UploadEditorController as J, GridController as ge, GridNotifyState as ve, WFDynaEditView3Controller as we } from "@ibiz-template/controller";
import { defineComponent as k, computed as T, h as c, getCurrentInstance as R, ref as g, watch as N, toRefs as B, onUnmounted as be } from "vue";
import { useNamespace as U, useViewController as Q, usePropsWatch as z, getUploadProps as ye, getEditorEmits as K, getGridUploadProps as _, getGridEditorEmits as $, useClickOutside as Ce, useEventListener as Fe, getInputProps as xe, getGridInputProps as Se, useGridCellEditor as ke, useControlController as Le, useWFStepTraceViewController as Ue, useEditView3Controller as Ee } from "@ibiz-template/vue-util";
import { colorBlend as Ne, HttpError as Y, isImage as Pe, uploadFile as Ie, RuntimeError as Te } from "@ibiz-template/core";
import { getCookie as De, createUUID as W } from "qx-util";
import { debounce as Re } from "lodash-es";
import { ViewMode as ee, UIActionHandler as te, PluginStaticResource as Ae } from "@ibiz-template/runtime";
const Me = k({
  name: "CodeListGridColumn",
  props: {
    controller: {
      type: Z,
      required: !0
    },
    row: {
      type: X,
      required: !0
    }
  },
  setup(e) {
    const t = U("grid-field-column"), s = T(() => {
      var r;
      if (e.controller.model.source.cLConvertMode !== "FRONT")
        return [];
      const n = e.row.data[e.controller.model.codeName];
      return (r = e.controller.codeListItems) != null && r.length && n ? n.split(",").map((h) => {
        const m = e.controller.codeListItems.find((f) => f.value === h);
        if (m) {
          const f = m.color || "#515a6e";
          return {
            text: m.text,
            colorStyle: t.cssVarBlock({
              color: f,
              "border-color": f,
              "bg-color": Ne(f, "#fff")
            })
          };
        }
      }).filter(Boolean) : [];
    }), o = (n) => {
      e.controller.isLinkColumn && e.controller.openLinkView(e.row, n);
    }, i = T(() => {
      let n = "";
      switch (e.controller.model.align) {
        case "LEFT":
          n = "flex-start";
          break;
        case "RIGHT":
          n = "flex-end";
          break;
        default:
          n = "center";
          break;
      }
      return t.cssVarBlock({
        "justify-content": n
      });
    });
    return {
      ns: t,
      alignStyle: i,
      selectedItems: s,
      onCellClick: o
    };
  },
  render() {
    const e = this.controller, t = this.row.data[e.model.codeName];
    return c("div", {
      class: [this.ns.b(), e.isLinkColumn && this.ns.m("link-column")],
      style: this.alignStyle,
      on: {
        click: this.onCellClick
      }
    }, [this.selectedItems.length > 0 ? this.selectedItems.map((s) => c("span", {
      class: this.ns.e("code-list-item"),
      style: s.colorStyle
    }, [s.text])) : c("span", {
      class: this.ns.e("text")
    }, [t])]);
  }
});
class Ge extends fe {
  constructor() {
    super(...arguments);
    /**
     * 流程图url
     *
     * @type {string}
     * @memberof PresetWFChartViewController
     */
    E(this, "imgSrc");
  }
  async getUIData() {
    const s = Object.assign(this.context.clone(), this.params), o = await this.entityService.wf.getWFProcessDiagram(s), i = new Blob([o.data], {
      type: "image/svg+xml"
    });
    this.imgSrc = URL.createObjectURL(i);
  }
}
const Oe = k({
  name: "PresetWFChartView",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    },
    deName: {
      type: String,
      required: !0
    }
  },
  setup(e) {
    const t = U("preset-wf-chart-view"), {
      proxy: s
    } = R(), o = Q(s, (i, n) => new Ge(e.modelPath, i, n));
    return z(s, "deName", o.setDeName.bind(o)), {
      c: o,
      ns: t
    };
  },
  render() {
    return c("div", {
      class: this.ns.b()
    }, [c("img", {
      attrs: {
        src: this.c.imgSrc
      }
    })]);
  }
});
const Be = k({
  name: "WFToolbar",
  props: {
    wfLinks: {
      type: Array,
      required: !0
    }
  },
  setup(e, {
    emit: t
  }) {
    const s = U("wf-toolbar"), o = async (n, r) => {
      t("wf-link-click", n, r);
    };
    return {
      ns: s,
      handleClick: async (n, r) => {
        setTimeout(() => {
          o(n, r);
        }, 30);
      }
    };
  },
  render() {
    const e = this.wfLinks || [];
    return c("div", {
      class: `${this.ns.b()}`
    }, [e.length > 0 && e.map((t) => {
      const s = t.sequenceFlowName == "驳回" || t.sequenceFlowName == "取消", o = t.sequenceFlowName.startsWith("保存") || t.sequenceFlowName.startsWith("关闭") || t.sequenceFlowName.startsWith("保存并关闭");
      return c("div", {
        key: t.sequenceFlowId,
        class: [this.ns.e("item"), o ? this.ns.em("item", "plain") : "", s ? this.ns.em("item", "reject") : ""]
      }, [c("i-button", {
        attrs: {
          title: t.sequenceFlowName
        },
        on: {
          click: (i) => this.handleClick(t, i)
        }
      }, [t.sequenceFlowName || ""])]);
    })]);
  }
}), ze = typeof btoa == "function", j = typeof Buffer == "function";
typeof TextDecoder == "function" && new TextDecoder();
const V = typeof TextEncoder == "function" ? new TextEncoder() : void 0, _e = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=", D = Array.prototype.slice.call(_e);
((e) => {
  let t = {};
  return e.forEach((s, o) => t[s] = o), t;
})(D);
const P = String.fromCharCode.bind(String);
typeof Uint8Array.from == "function" && Uint8Array.from.bind(Uint8Array);
const $e = (e) => e.replace(/=/g, "").replace(/[+\/]/g, (t) => t == "+" ? "-" : "_"), je = (e) => {
  let t, s, o, i, n = "";
  const r = e.length % 3;
  for (let a = 0; a < e.length; ) {
    if ((s = e.charCodeAt(a++)) > 255 || (o = e.charCodeAt(a++)) > 255 || (i = e.charCodeAt(a++)) > 255)
      throw new TypeError("invalid character found");
    t = s << 16 | o << 8 | i, n += D[t >> 18 & 63] + D[t >> 12 & 63] + D[t >> 6 & 63] + D[t & 63];
  }
  return r ? n.slice(0, r - 3) + "===".substring(r) : n;
}, se = ze ? (e) => btoa(e) : j ? (e) => Buffer.from(e, "binary").toString("base64") : je, We = j ? (e) => Buffer.from(e).toString("base64") : (e) => {
  let s = [];
  for (let o = 0, i = e.length; o < i; o += 4096)
    s.push(P.apply(null, e.subarray(o, o + 4096)));
  return se(s.join(""));
}, Ve = (e) => {
  if (e.length < 2) {
    var t = e.charCodeAt(0);
    return t < 128 ? e : t < 2048 ? P(192 | t >>> 6) + P(128 | t & 63) : P(224 | t >>> 12 & 15) + P(128 | t >>> 6 & 63) + P(128 | t & 63);
  } else {
    var t = 65536 + (e.charCodeAt(0) - 55296) * 1024 + (e.charCodeAt(1) - 56320);
    return P(240 | t >>> 18 & 7) + P(128 | t >>> 12 & 63) + P(128 | t >>> 6 & 63) + P(128 | t & 63);
  }
}, qe = /[\uD800-\uDBFF][\uDC00-\uDFFFF]|[^\x00-\x7F]/g, He = (e) => e.replace(qe, Ve), q = j ? (e) => Buffer.from(e, "utf8").toString("base64") : V ? (e) => We(V.encode(e)) : (e) => se(He(e)), oe = (e, t = !1) => t ? $e(q(e)) : q(e);
function Ze(e, t, s) {
  var S;
  const o = g([]), i = g({
    Authorization: `Bearer ${De("access_token")}`
  }), n = g(""), r = g(""), a = {
    count: 0,
    cacheFiles: []
    // iview上传过程中不能改default-file-list,所以需要缓存
  }, d = (S = s.editorParams) == null ? void 0 : S.blackList;
  let h = [];
  d && typeof d == "string" && (h = d.split(",")), N(
    () => e.value,
    (l) => {
      o.value = l ? JSON.parse(l) : [];
    },
    { immediate: !0 }
  ), N(
    () => e.data,
    (l) => {
      if (l) {
        const u = s.calcBaseUrl(l);
        n.value = u.uploadUrl, r.value = u.downloadUrl;
      }
    },
    { immediate: !0, deep: !0 }
  ), N(
    o,
    (l) => {
      l != null && l.length && r.value && l.forEach((u) => {
        u.url = u.url || r.value.replace("%fileId%", u.id);
      });
    },
    { immediate: !0 }
  ), N(
    r,
    (l) => {
      l && o.value.length && o.value.forEach((u) => {
        u.url = r.value.replace("%fileId%", u.id);
      });
    },
    { immediate: !0 }
  );
  const m = () => {
    const l = [...o.value, ...a.cacheFiles], u = l.length > 0 ? JSON.stringify(l.map((w) => ({ name: w.name, id: w.id }))) : null;
    a.cacheFiles = [], t(u);
  }, f = (l) => {
    const u = l.name.trim().toLowerCase();
    if (h.some((x) => u.endsWith(`.${x}`)))
      return ibiz.message.error(`不可上传 ${h.join("、")}类型的文件！`), !1;
    a.count += 1;
  }, C = (l) => {
    l && (a.cacheFiles.push({
      name: l.filename,
      id: l.fileid
    }), a.count -= 1, a.count === 0 && m());
  }, b = (l, u) => {
    throw a.count -= 1, new Y({
      response: { data: u, status: l.status }
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
    });
  }, F = (l) => {
    if (e.disabled)
      return;
    const u = o.value.findIndex((w) => w.id === l.id);
    u !== -1 && o.value.splice(u, 1), m();
  }, v = (l) => {
    const u = l.url || r.value.replace("%fileId%", l.id);
    s.fileDownload({ url: u, name: l.name });
  }, p = g(!1), y = g(""), I = g("");
  return {
    uploadUrl: n,
    downloadUrl: r,
    headers: i,
    files: o,
    onDownload: v,
    onError: b,
    onRemove: F,
    onSuccess: C,
    beforeUpload: f,
    showModal: p,
    modalTitle: y,
    iframeUrl: I,
    onModalCancel: () => {
      p.value = !1, y.value = "", I.value = "";
    },
    previewFile: (l) => {
      p.value = !0, y.value = l.name;
      const u = window.Environment.previewFileUrl;
      if (u) {
        const w = encodeURIComponent(
          oe(
            `${window.location.origin}${l.url}?fullfilename=${l.name}`
          )
        );
        I.value = `${u}/onlinePreview?url=${w}`;
      }
    }
  };
}
const Xe = k({
  name: "SyFileUpload",
  props: ye(),
  emits: K(),
  setup(e, {
    emit: t
  }) {
    const s = U("sy-file-upload"), o = e.controller, {
      uploadUrl: i,
      headers: n,
      files: r,
      onDownload: a,
      onError: d,
      onRemove: h,
      onSuccess: m,
      beforeUpload: f,
      showModal: C,
      modalTitle: b,
      iframeUrl: F,
      onModalCancel: v,
      previewFile: p
    } = Ze(e, (y) => {
      t("change", y);
    }, o);
    return {
      ns: s,
      c: o,
      uploadUrl: i,
      headers: n,
      files: r,
      onDownload: a,
      onError: d,
      onRemove: h,
      onSuccess: m,
      beforeUpload: f,
      showModal: C,
      modalTitle: b,
      iframeUrl: F,
      onModalCancel: v,
      previewFile: p
    };
  },
  render(e) {
    return e("div", {
      class: [this.ns.b(), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [e("IUpload", {
      ref: "fileUpload",
      props: {
        action: this.uploadUrl,
        headers: this.headers,
        disabled: this.disabled,
        "default-file-list": this.files,
        multiple: this.c.model.multiple,
        type: this.c.model.isDrag ? "drag" : "select",
        accept: this.c.model.accept,
        "before-upload": this.beforeUpload,
        "on-success": this.onSuccess,
        "on-error": this.onError,
        "on-remove": this.onRemove,
        "on-preview": this.onDownload,
        "show-upload-list": !1
      }
    }, [this.c.model.isDrag ? e("div", {
      class: this.ns.bm("box", "drag")
    }, [e("i-icon", {
      attrs: {
        type: "md-cloud-upload"
      }
    }), e("div", {
      class: this.ns.be("box", "title")
    }, [e("span", ["将文件拖到此处，或"]), e("span", ["点击上传"])])]) : e("i-button", {
      class: this.ns.bm("box", "select")
    }, [e("svg", {
      attrs: {
        xmlns: "http://www.w3.org/2000/svg",
        viewBox: "0 0 1024 1024"
      }
    }, [e("path", {
      attrs: {
        fill: "currentColor",
        d: "M160 832h704a32 32 0 1 1 0 64H160a32 32 0 1 1 0-64m384-578.304V704h-64V247.296L237.248 490.048 192 444.8 508.8 128l316.8 316.8-45.312 45.248z"
      }
    })]), e("span", ["上传文件"])]), this.c.uploadDescription && e("div", {
      class: this.ns.b("accept-description")
    }, [this.c.uploadDescription])]), e("div", {
      class: this.ns.b("file-list")
    }, [this.files.map((t) => e("div", {
      class: this.ns.b("file-item"),
      key: t.id
    }, [e("div", {
      class: this.ns.b("file-item-right")
    }, [e("div", {
      class: this.ns.b("file-item-right-icon")
    }, [e("svg", {
      attrs: {
        viewBox: "0 0 16 16",
        version: "1.1"
      }
    }, [e("g", {
      attrs: {
        id: "基础组件",
        stroke: "none",
        "stroke-width": "1",
        fill: "none",
        "fill-rule": "evenodd"
      }
    }, [e("g", {
      attrs: {
        id: "Upload上传",
        transform: "translate(-128.000000, -1899.000000)",
        "fill-rule": "nonzero"
      }
    }, [e("g", {
      attrs: {
        id: "关联",
        transform: "translate(128.000000, 1899.000000)"
      }
    }, [e("rect", {
      attrs: {
        id: "矩形备份-20",
        x: "0",
        y: "0",
        width: "16",
        height: "16"
      }
    }), e("path", {
      attrs: {
        d: "M8,6.25590375 C9.72432306,6.25590375 11.1277921,7.62964308 11.175675,9.34238963 L11.1769379,9.43284162 L11.1769379,12.7456325 C11.1769379,14.5002069 9.75457434,15.9225704 8,15.9225704 C6.27567694,15.9225704 4.8722079,14.5488311 4.824325,12.8360845 L4.82306213,12.7456325 L4.82306213,10.7559037 C4.82306213,10.4797614 5.04691975,10.2559037 5.32306213,10.2559037 C5.58296083,10.2559037 5.79654502,10.4541998 5.82077327,10.7077504 L5.82306213,10.7559037 L5.82306213,12.7456325 C5.82306213,13.9479221 6.79771041,14.9225704 8,14.9225704 C9.17615286,14.9225704 10.1344543,13.9898375 10.1755637,12.8237123 L10.1769379,12.7456325 L10.1769379,9.43284162 C10.1769379,8.23055203 9.20228959,7.25590375 8,7.25590375 C7.72385763,7.25590375 7.5,7.03204612 7.5,6.75590375 C7.5,6.47976137 7.72385763,6.25590375 8,6.25590375 Z M8,0.0774295852 C9.72432306,0.0774295852 11.1277921,1.45116892 11.175675,3.16391546 L11.1769379,3.25436746 L11.1769379,5.24409625 C11.1769379,5.52023863 10.9530802,5.74409625 10.6769379,5.74409625 C10.4170392,5.74409625 10.203455,5.54580022 10.1792267,5.29224959 L10.1769379,5.24409625 L10.1769379,3.25436746 C10.1769379,2.05207787 9.20228959,1.07742959 8,1.07742959 C6.82384714,1.07742959 5.86554572,2.01016247 5.82443628,3.17628769 L5.82306213,3.25436746 L5.82306213,6.56715838 C5.82306213,7.76944797 6.79771041,8.74409625 8,8.74409625 C8.27614237,8.74409625 8.5,8.96795388 8.5,9.24409625 C8.5,9.52023863 8.27614237,9.74409625 8,9.74409625 C6.27567694,9.74409625 4.8722079,8.37035692 4.824325,6.65761037 L4.82306213,6.56715838 L4.82306213,3.25436746 C4.82306213,1.49979312 6.24542566,0.0774295852 8,0.0774295852 Z",
        id: "形状结合",
        fill: "#000000",
        transform: "translate(8.000000, 8.000000) rotate(-315.000000) translate(-8.000000, -8.000000) "
      }
    })])])])])]), e("div", {
      class: this.ns.b("file-item-right-title"),
      on: {
        click: () => this.previewFile(t)
      }
    }, [t.name]), e("div", {
      class: this.ns.b("file-item-right-action")
    }, [e("span", {
      class: this.ns.e("icon-download"),
      on: {
        click: () => this.onDownload(t)
      }
    }, [e("svg", {
      attrs: {
        width: "16px",
        height: "16px",
        viewBox: "0 0 16 16",
        version: "1.1",
        fill: "currentColor"
      }
    }, [e("g", {
      attrs: {
        id: "icon",
        stroke: "none",
        "stroke-width": "1",
        "fill-rule": "evenodd"
      }
    }, [e("g", {
      attrs: {
        id: "编组"
      }
    }, [e("path", {
      attrs: {
        d: "M7.33333333,8.77086667 L7.33333333,1.66666667 L8.66666667,1.66666667 L8.66666667,8.7716 L10.5526333,6.88563333 L11.4954333,7.82843333 L8.00036667,11.3235333 L4.50526667,7.82843333 L5.44806667,6.88563333 L7.33333333,8.77086667 Z M2,13 L2,14.3333333 L14,14.3333333 L14,13 L2,13 Z",
        id: "形状",
        fill: "currentColor",
        "fill-rule": "nonzero"
      }
    }), e("rect", {
      attrs: {
        id: "矩形",
        fill: "#000000",
        "fill-rule": "nonzero",
        opacity: "0",
        x: "0",
        y: "0",
        width: "16",
        height: "16"
      }
    })])])])]), e("span", {
      class: this.ns.e("icon-preview"),
      on: {
        click: () => this.previewFile(t)
      }
    }, [e("svg", {
      attrs: {
        width: "16px",
        height: "17px",
        viewBox: "0 0 16 17",
        version: "1.1",
        fill: "currentColor",
        xmlns: "http://www.w3.org/2000/svg"
      }
    }, [e("g", {
      attrs: {
        id: "icon",
        stroke: "none",
        "stroke-width": "1",
        fill: "none",
        "fill-rule": "evenodd"
      }
    }, [e("g", {
      attrs: {
        id: "eye",
        transform: "translate(-7.9982, -7.6008)",
        fill: "currentColor"
      }
    }, [e("g", {
      attrs: {
        transform: "translate(8, 8)",
        id: "编组"
      }
    }, [e("path", {
      attrs: {
        d: "M1.43340667,7.64873333 C3.27632667,4.67586667 5.45346667,3 8.00003333,3 C10.5466,3 12.7237333,4.67586667 14.5666667,7.64873333 L14.7844,8 L14.5666667,8.35126667 C12.7237333,11.3241333 10.5466,13 8.00003333,13 C5.45346667,13 3.27632667,11.3241333 1.43340667,8.35126667 L1.21565667,8 L1.43340667,7.64873333 Z M2.79026333,8 C4.4615,10.5552333 6.2084,11.6666667 8.00003333,11.6666667 C9.79166667,11.6666667 11.5385667,10.5552333 13.2098,8 C11.5385667,5.44476667 9.79166667,4.33333333 8.00003333,4.33333333 C6.2084,4.33333333 4.4615,5.44476667 2.79026333,8 Z M8.00003333,7 C7.44773333,7 7.00003333,7.4477 7.00003333,8 C7.00003333,8.5523 7.44773333,9 8.00003333,9 C8.5523,9 9.00003333,8.5523 9.00003333,8 C9.00003333,7.4477 8.5523,7 8.00003333,7 Z M5.6667,8 C5.6667,6.71133333 6.71136667,5.66666667 8.00003333,5.66666667 C9.2887,5.66666667 10.3333667,6.71133333 10.3333667,8 C10.3333667,9.28866667 9.2887,10.3333333 8.00003333,10.3333333 C6.71136667,10.3333333 5.6667,9.28866667 5.6667,8 Z",
        id: "形状",
        "fill-rule": "nonzero"
      }
    }), e("rect", {
      attrs: {
        id: "矩形",
        "fill-rule": "nonzero",
        opacity: "0",
        x: "0",
        y: "0",
        width: "16",
        height: "16"
      }
    })])])])])]), this.disabled || this.readonly ? null : e("span", {
      class: this.ns.e("icon-remove"),
      on: {
        click: () => this.onRemove(t)
      }
    }, [e("svg", {
      attrs: {
        width: "16px",
        height: "16px",
        viewBox: "0 0 16 16",
        version: "1.1",
        fill: "currentColor"
      }
    }, [e("g", {
      attrs: {
        id: "基础组件",
        stroke: "none",
        "stroke-width": "1",
        fill: "none",
        "fill-rule": "evenodd"
      }
    }, [e("g", {
      attrs: {
        id: "Upload上传",
        transform: "translate(-544.000000, -930.000000)",
        "fill-rule": "nonzero"
      }
    }, [e("g", {
      attrs: {
        id: "删除",
        transform: "translate(544.000000, 930.000000)"
      }
    }, [e("rect", {
      attrs: {
        id: "矩形备份-12",
        x: "0",
        y: "0",
        width: "16",
        height: "16"
      }
    }), e("path", {
      attrs: {
        d: "M14.484375,2.84895833 C14.7609375,2.84895833 14.984375,3.07239583 14.984375,3.34895833 C14.984375,3.62552083 14.7609375,3.84895833 14.484375,3.84895833 L13,3.84895833 L13,14.1822917 C13,14.5504815 12.7015232,14.8489583 12.3333333,14.8489583 L3.66666667,14.8489583 C3.29847683,14.8489583 3,14.5504815 3,14.1822917 L3,3.84895833 L3,3.84895833 L1.5,3.84895833 C1.2234375,3.84895833 1,3.62552083 1,3.34895833 C1,3.07239583 1.2234375,2.84895833 1.5,2.84895833 L14.484375,2.84895833 Z M12,3.84895833 L4,3.84895833 L4,13.8489583 L12,13.8489583 L12,3.84895833 Z M6.5,5.84895833 C6.7765625,5.84895833 7,6.07239583 7,6.34895833 L7,11.3458333 C7,11.6223958 6.775,11.8458333 6.5,11.8458333 C6.2234375,11.8458333 6,11.6223958 6,11.3458333 L6,6.34895833 C6,6.07239583 6.2234375,5.84895833 6.5,5.84895833 Z M9.5,5.84895833 C9.7765625,5.84895833 10,6.07239583 10,6.34895833 L10,11.3458333 C10,11.6223958 9.775,11.8458333 9.5,11.8458333 C9.2234375,11.8458333 9,11.6223958 9,11.3458333 L9,6.34895833 C9,6.07239583 9.2234375,5.84895833 9.5,5.84895833 Z M10.5,0.847395833 C10.7765625,0.847395833 11,1.07083333 11,1.34739583 C11,1.62395833 10.7765625,1.84739583 10.5,1.84739583 L5.484375,1.84739583 C5.2078125,1.84739583 4.984375,1.62395833 4.984375,1.34739583 C4.984375,1.07083333 5.2078125,0.847395833 5.484375,0.847395833 L10.5,0.847395833 Z",
        id: "形状结合",
        fill: "currentColor"
      }
    })])])])])])])])]))]), e("i-modal", {
      attrs: {
        value: this.showModal,
        title: this.modalTitle,
        "class-name": this.ns.b("modal"),
        width: "70%",
        transfer: !1,
        "footer-hide": !0
      },
      on: {
        "on-cancel": this.onModalCancel
      }
    }, [e("iframe", {
      class: this.ns.b("iframe"),
      attrs: {
        src: this.iframeUrl
      }
    })])]);
  }
});
function G(e, t) {
  if (e.url = t.replace("%fileId%", e.id), e.status || (e.status = "finished"), !e.fileName) {
    const s = e.name.lastIndexOf(".");
    e.fileName = e.name.substring(0, s), e.fileExt = e.name.substring(s), e.isImage = Pe(e.name);
  }
  return e;
}
function ie(e) {
  const t = g(""), s = g(""), o = g([]);
  return N(
    e.data,
    (i) => {
      if (i) {
        const n = e.controller.value.calcBaseUrl(i);
        t.value = n.uploadUrl, s.value = n.downloadUrl;
      }
    },
    { immediate: !0, deep: !0 }
  ), N(
    e.value,
    (i) => {
      o.value = i ? JSON.parse(i) : [], o.value.length && s.value && o.value.forEach((n) => {
        G(n, s.value);
      });
    },
    { immediate: !0 }
  ), N(
    s,
    (i) => {
      i && o.value.length && o.value.forEach((n) => {
        G(n, i);
      });
    },
    { immediate: !0 }
  ), {
    downloadUrl: s,
    uploadUrl: t,
    valueList: o
  };
}
function ne(e) {
  var L, S;
  const t = g("undo"), s = g([]), { downloadUrl: o, value: i, uploadUrl: n, controller: r } = e, a = (S = (L = r == null ? void 0 : r.value) == null ? void 0 : L.editorParams) == null ? void 0 : S.blackList;
  let d = [];
  a && typeof a == "string" && (d = a.split(",")), N(
    i,
    (l) => {
      l.length > 0 && (s.value = [], l.forEach((u) => {
        s.value.push(G(u, o.value));
      }));
    },
    {
      immediate: !0,
      deep: !0
    }
  );
  const h = (l, u) => {
    const w = [];
    return u.forEach((x, A) => {
      const M = x.name.trim().toLowerCase();
      if (d.some((le) => M.endsWith(`.${le}`))) {
        w.push(A);
        return;
      }
      s.value.push({
        name: x.name,
        status: x.status,
        percentage: x.percentage,
        id: x.uid,
        url: ""
      });
    }), w.length === u.length ? (ibiz.message.error(`不可上传 ${d.join("、")}类型的文件！`), !1) : (w.length && (w.forEach((x) => {
      l.splice(x, 1), u.splice(x, 1);
    }), ibiz.message.error(`不可上传 ${d.join("、")}类型的文件！`)), !0);
  }, m = (l) => {
    l.forEach((u) => {
      s.value.find((w) => w.id === u.uid ? (w.percentage = u.percentage, !0) : !1);
    });
  }, f = (l, u) => {
    l.forEach((w) => {
      s.value.find((x) => x.id === w.uid ? (x.status = w.status, x.id = u.data.fileid, x.name = u.data.filename, G(x, o.value), !0) : !1);
    });
  }, C = (l, u) => {
    var x;
    l.forEach((A) => {
      s.value.find((M) => M.id === A.uid ? (M.status = A.status, !0) : !1);
    });
    const w = new Y(u);
    ibiz.notification.error({
      title: (x = w.status) == null ? void 0 : x.toString(),
      desc: w.message,
      duration: 10
    });
  }, b = (l) => {
    s.value = s.value.filter((u) => u.status === "finished"), t.value = "done";
  }, F = () => {
    Ie({
      multiple: e.multiple,
      accept: e.accept,
      uploadUrl: n.value,
      beforeUpload: h,
      progress: m,
      success: f,
      error: C,
      finish: b
    });
  }, v = g(!1), p = g(""), y = g("");
  return {
    selectFile: F,
    fileList: s,
    uploadState: t,
    showModal: v,
    modalTitle: p,
    iframeUrl: y,
    onModalCancel: () => {
      v.value = !1, p.value = "", y.value = "";
    },
    previewFile: (l) => {
      v.value = !0, p.value = l.name;
      const u = window.Environment.previewFileUrl;
      if (u) {
        const w = encodeURIComponent(
          oe(
            `${window.location.origin}${l.url}?fullfilename=${l.name}`
          )
        );
        y.value = `${u}/onlinePreview?url=${w}`;
      }
    }
  };
}
const Je = k({
  name: "SyGridFileUpload",
  props: _(),
  setup(e) {
    const t = U("sy-grid-file-upload"), {
      value: s,
      data: o,
      controller: i
    } = B(e), {
      downloadUrl: n,
      uploadUrl: r,
      valueList: a
    } = ie({
      value: s,
      data: o,
      controller: i
    }), {
      fileList: d,
      showModal: h,
      modalTitle: m,
      iframeUrl: f,
      previewFile: C,
      onModalCancel: b
    } = ne({
      downloadUrl: n,
      uploadUrl: r,
      value: a
    });
    return {
      ns: t,
      fileList: d,
      showModal: h,
      modalTitle: m,
      iframeUrl: f,
      downloadFile: (v) => {
        e.controller.fileDownload(v);
      },
      previewFile: C,
      onModalCancel: b
    };
  },
  render() {
    return c("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      class: [this.ns.b(), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [c("div", {
      class: this.ns.b("file-list")
    }, [this.fileList.map((e) => c("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [c("div", {
      class: this.ns.b("file-item-title"),
      on: {
        click: () => this.previewFile(e)
      }
    }, [e.name]), c("div", {
      class: this.ns.b("file-item-action")
    }, [c("i-icon", {
      attrs: {
        type: "md-download"
      },
      on: {
        click: () => this.downloadFile(e)
      }
    }), c("i-icon", {
      attrs: {
        type: "md-eye"
      },
      on: {
        click: () => this.previewFile(e)
      }
    })])]))]), c("i-modal", {
      attrs: {
        value: this.showModal,
        title: this.modalTitle,
        "class-name": this.ns.b("modal"),
        width: "70%",
        transfer: !1,
        "footer-hide": !0
      },
      on: {
        "on-cancel": this.onModalCancel
      }
    }, [c("iframe", {
      class: this.ns.b("iframe"),
      attrs: {
        src: this.iframeUrl
      }
    })])]);
  }
}), Qe = k({
  name: "SyGridFileUploadContainer",
  props: _(),
  emits: $(),
  render(e) {
    return this.disabled || this.readonly ? e("SyGridFileUpload", {
      props: {
        ...this.$props
      }
    }) : e("SyEditGridFileUpload", {
      props: {
        ...this.$props
      },
      on: {
        change: (t, s) => {
          this.$emit("change", t, s);
        },
        rowSave: () => {
          this.$emit("rowSave");
        }
      }
    });
  }
});
const Ke = k({
  name: "SyEditGridFileUploadPopover",
  props: {
    uploadUrl: {
      type: String,
      required: !0
    },
    downloadUrl: {
      type: String,
      required: !0
    },
    value: {
      type: Array,
      required: !0
    },
    controller: {
      type: J,
      required: !0
    }
  },
  emits: {
    close: (e) => !0
  },
  setup(e, {
    emit: t
  }) {
    const s = U("sy-edit-grid-file-upload-popover"), {
      downloadUrl: o,
      value: i,
      uploadUrl: n,
      controller: r
    } = B(e), {
      fileList: a,
      uploadState: d,
      selectFile: h
    } = ne({
      downloadUrl: o,
      value: i,
      uploadUrl: n,
      controller: r
    }), m = g(), f = g(!1), C = Ce(m, async (v) => {
      t("close", {
        isModified: f.value,
        resultFiles: a.value
      });
    });
    return N(d, (v) => {
      v === "done" ? (f.value = !0, C.proceed()) : v === "loading" && C.pause();
    }), {
      ns: s,
      componentRef: m,
      fileList: a,
      deleteFile: (v) => {
        const p = a.value.findIndex((y) => y.id === v.id);
        a.value.splice(p, 1), f.value = !0;
      },
      selectFile: h,
      downloadFile: (v) => {
        e.controller.fileDownload(v);
      }
    };
  },
  render() {
    return c("div", {
      ref: "componentRef",
      style: "width:300px",
      class: this.ns.b()
    }, [c("div", {
      class: this.ns.b("file-list")
    }, [this.fileList.map((e) => c("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [c("div", {
      class: this.ns.b("file-item-title"),
      on: {
        click: () => this.downloadFile(e)
      }
    }, [e.name]), c("div", {
      class: this.ns.b("file-item-action")
    }, [c("i-icon", {
      attrs: {
        type: "md-close"
      },
      on: {
        click: () => this.deleteFile(e)
      }
    })])]))]), c("div", {
      on: {
        click: () => this.selectFile()
      },
      class: this.ns.e("button")
    }, [c("i-icon", {
      attrs: {
        type: "md-add"
      }
    }), "添加文件"])]);
  }
});
const Ye = k({
  name: "SyEditGridFileUpload",
  props: _(),
  emits: $(),
  setup(e, {
    emit: t
  }) {
    const s = U("sy-edit-grid-file-upload"), {
      value: o,
      data: i,
      controller: n
    } = B(e), {
      downloadUrl: r,
      uploadUrl: a,
      valueList: d
    } = ie({
      value: o,
      data: i,
      controller: n
    }), h = g(), m = async () => {
      if (!h.value)
        throw new Te("容器元素不存在");
      const f = h.value.$el, C = f.offsetHeight, b = ibiz.overlay.createPopover((p) => p(Ke, {
        props: {
          value: d.value,
          uploadUrl: a.value,
          downloadUrl: r.value,
          controller: n.value
        },
        on: {
          close: (y) => {
            b.dismiss(y);
          }
        }
      }), void 0, {
        noArrow: !0,
        placement: "bottom-start",
        offsetOpts: {
          mainAxis: -C,
          crossAxis: 0
        }
      });
      await b.present(f);
      const {
        isModified: F,
        resultFiles: v
      } = await b.onWillDismiss();
      if (F) {
        const p = v.length > 0 ? JSON.stringify(v.map((y) => ({
          name: y.name,
          id: y.id
        }))) : null;
        t("change", p), t("rowSave");
      }
    };
    return Fe(h, "click", (f) => {
      e.disabled || m();
    }), {
      ns: s,
      valueList: d,
      componentRef: h
    };
  },
  render() {
    return c("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      ref: "componentRef",
      class: this.ns.b()
    }, [c("div", {
      class: this.ns.b("file-list")
    }, [this.valueList.map((e) => c("div", {
      class: this.ns.b("file-item"),
      key: e.id
    }, [c("div", {
      class: this.ns.b("file-item-title")
    }, [e.name])]))])]);
  }
});
k({
  name: "SyInput",
  props: xe(),
  emits: K(),
  setup(e, {
    emit: t
  }) {
    const s = U("input"), i = e.controller.model, n = g(), r = g(2);
    i.editorType === "TEXTAREA_10" && (r.value = 10);
    const a = T(() => {
      switch (i.editorType) {
        case "TEXTBOX":
          return "text";
        case "PASSWORD":
          return "password";
        case "TEXTAREA":
        case "TEXTAREA_10":
          return "textarea";
        default:
          return "string";
      }
    }), d = g("");
    N(() => e.value, (p, y) => {
      p !== y && (p ? d.value = p : d.value = "");
    }, {
      immediate: !0
    });
    let h = !1, m, f;
    const C = Re((p) => {
      f !== p.target.value && t("change", p.target.value), f = void 0, h = !1, m && m();
    }, 300, {
      leading: !0
    }), b = (p) => {
      h = !0, C(p);
    }, F = (p) => {
      p && p.code === "Enter" && h && (m = () => {
        n.value.$el.dispatchEvent(p);
      });
    }, v = () => {
      f = n.value.currentValue, t("change", f);
    };
    return e.autoFocus && N(n, (p) => {
      p && p.$el.getElementsByTagName("input")[0].focus();
    }), {
      ns: s,
      rows: r,
      type: a,
      currentVal: d,
      handleChange: b,
      handleKeyUp: F,
      handleBlur: v,
      inputRef: n
    };
  },
  render() {
    return c("div", {
      class: [this.ns.b(), this.ns.b("sy-input"), this.ns.is("textarea", Object.is(this.type, "textarea")), this.disabled ? this.ns.m("disabled") : "", this.readonly ? this.ns.m("readonly") : ""]
    }, [this.readonly ? this.currentVal : c("i-input", {
      ref: "inputRef",
      attrs: {
        value: this.currentVal,
        placeholder: this.controller.placeHolder,
        type: this.type,
        rows: this.rows,
        disabled: this.disabled,
        autosize: Object.is(this.type, "textarea")
      },
      on: {
        "on-change": this.handleChange,
        "on-blur": this.handleBlur
      },
      nativeOn: {
        keyup: this.handleKeyUp
      },
      class: this.ns.b("input")
    }, [this.controller.model.unitName && c("i", {
      class: this.ns.e("unit"),
      slot: "suffix"
    }, [this.controller.model.unitName])])]);
  }
});
k({
  name: "SyGridInput",
  props: Se(),
  emits: $(),
  setup(e, {
    emit: t
  }) {
    const s = U("grid-input"), {
      isInfoMode: o,
      autoFocus: i,
      componentRef: n,
      onOperateChange: r,
      onChange: a
    } = ke(e, {
      emit: t
    });
    return {
      ns: s,
      isInfoMode: o,
      autoFocus: i,
      componentRef: n,
      onOperateChange: r,
      onChange: a
    };
  },
  render(e) {
    return e("grid-editor", {
      attrs: {
        disabled: this.disabled,
        readonly: this.readonly
      },
      ref: "componentRef",
      class: `${this.ns.b()}`
    }, [e("SyInput", {
      props: {
        ...this.$props,
        readonly: this.isInfoMode,
        disabled: this.disabled,
        autoFocus: this.autoFocus
      },
      on: {
        change: this.onChange,
        operate: this.onOperateChange
      }
    })]);
  }
});
function H(e, t) {
  return c("div", {
    class: e.e("logo")
  }, [t.appIconPath ? c("img", {
    class: e.e("logo-img"),
    attrs: {
      src: t.appIconPath
    }
  }) : null, c("div", {
    class: e.e("logo-caption")
  }, [t.caption])]);
}
const et = k({
  name: "UserAppLayout",
  props: {
    model: {
      type: ue,
      required: !0
    },
    // 视图是否完成加载
    isComplete: {
      type: Boolean,
      default: !1
    },
    // 是否显示分页导航
    isShowTabPageExp: {
      type: Boolean,
      default: !1
    }
  },
  setup(e, {
    emit: t
  }) {
    const s = U("layout"), o = g(!1), i = () => {
      o.value = !o.value, t("onCollapseChange", o.value);
    }, n = T(() => e.model.source.blankMode === !0), r = T(() => !!(window.Environment.manualdownloadurl || ibiz.env.manualdownloadurl));
    return {
      ns: s,
      collapseChange: o,
      isBlank: n,
      collapseMenus: i,
      isShowDownload: r,
      downloadUserBook: () => {
        const d = window.Environment.manualdownloadurl || ibiz.env.manualdownloadurl;
        d ? window.open(d) : console.log("环境变量里没有manualdownloadurl");
      }
    };
  },
  render() {
    return this.isComplete ? c("i-layout", {
      class: [this.ns.b(), this.isBlank ? this.ns.m("blank") : "", this.ns.is("collapse", this.collapseChange), this.ns.is("tab", this.isShowTabPageExp), "user-layout"]
    }, [c("i-sider", {
      attrs: {
        "hide-trigger": !0,
        value: this.collapseChange
      },
      class: [this.ns.b("nav"), this.ns.is("collapse", this.collapseChange)]
    }, [H(this.ns, this.model), this.$slots.menu]), c("i-layout", {
      class: [this.ns.b("content")]
    }, [c("i-header", {
      class: this.ns.b("header")
    }, [c("div", {
      class: this.ns.be("header", "left")
    }, [H(this.ns, this.model), c("div", {
      class: this.ns.be("header", "collapse-icon")
    }, [this.collapseChange ? c("ion-icon", {
      attrs: {
        src: "./assets/img/menu-unfold.svg"
      },
      on: {
        click: () => this.collapseMenus()
      }
    }) : c("ion-icon", {
      attrs: {
        src: "./assets/img/menu-fold.svg"
      },
      on: {
        click: () => this.collapseMenus()
      }
    })]), this.model.source.mainMenuAlign === "TOP" ? c("i-menu", {
      class: this.ns.be("header", "menu"),
      attrs: {
        mode: "horizontal",
        "active-name": "1"
      }
    }) : null]), c("div", {
      class: this.ns.be("header", "right")
    }, [this.isShowDownload && c("div", {
      class: "user-download",
      on: {
        click: () => this.downloadUserBook()
      }
    }, ["用户手册下载"]), c("app-user")])]), c("i-content", {
      class: this.ns.be("content", "main")
    }, [this.$slots.tabPageExp, this.$slots.default])])]) : null;
  }
});
function re(e, t) {
  var n;
  const s = t.firstColName, o = [];
  e.source.columnType === "GROUPGRIDCOLUMN" && e.children.forEach((r) => {
    o.push(re(r, t));
  });
  const i = {
    title: e.title,
    width: e.source.widthUnit === "STAR" ? void 0 : e.width,
    minWidth: e.width,
    align: ((n = e.source.align) == null ? void 0 : n.toLowerCase()) || "center",
    slot: e.codeName,
    key: e.codeName,
    fieldName: e.deFieldName,
    ellipsis: !0,
    tooltip: !1,
    // todo 表格提示用title
    resizable: !0,
    sortable: !t.noSort && e.source.enableSort ? "custom" : !1,
    columnType: e.source.columnType,
    tree: e.codeName === s,
    className: e.codeName === s ? "grid-group-grid-column" : ""
  };
  return o.length > 0 && Object.assign(i, { children: o }), i;
}
function tt(e) {
  const t = e.model, s = [], o = t.columns.map((i) => re(i, e));
  return t.children.forEach((i) => {
    const n = o.find((a) => a.key === i.codeName), r = e.groupField;
    n && i.codeName !== r && s.push(n);
  }), e.singleSelect || s.splice(0, 0, { type: "selection", width: 60 }), s;
}
function st(e) {
  const t = g([]);
  return e.nerve.self.evt.on("created", () => {
    t.value = tt(e);
  }), [T(() => {
    const o = [...t.value];
    if (!o.find((r) => !r.width)) {
      let r = o.length - 1;
      o[r].key === "rowEdit" && (r -= 1), o[r] = {
        ...o[r],
        width: void 0
      };
    }
    const n = o.find((r) => r.columnType === "UAGRIDCOLUMN");
    return n && (n.fixed = "right"), o;
  }), t];
}
function ot(e) {
  const t = (r) => e.items.find((a) => a.srfkey === r.srfkey);
  function s(r) {
    const a = t(r);
    e.singleSelect && e.onSelectionChange([a]), e.onRowClick(a);
  }
  function o(r) {
    e.onDbRowClick(t(r));
  }
  function i(r) {
    if (!e.singleSelect) {
      const a = [];
      r.forEach((d) => {
        const h = t(d);
        h && a.push(h);
      }), e.onSelectionChange(a);
    }
  }
  function n(r) {
    const { column: a, order: d } = r, h = d === "asc" || d === "desc" ? d : void 0;
    e.setSort(a.fieldName, h), e.load();
  }
  return { onRowClick: s, onDbRowClick: o, onSelectionChange: i, onSortChange: n };
}
function it(e) {
  function t(i) {
    !i || i === e.curPage || (e.curPage = i, e.load());
  }
  function s(i) {
    !i || i === e.size || (e.size = i, e.curPage === 1 && e.load());
  }
  function o() {
    e.curPage = 1, e.load();
  }
  return { onPageChange: t, onPageSizeChange: s, onPageReset: o };
}
class nt extends ge {
  constructor() {
    super(...arguments);
    /**
     * 分组数据
     * @return {*}
     * @author: zhujiamin
     * @Date: 2023-10-09 14:00:38
     */
    E(this, "groups", []);
    /**
     * 分组名称属性
     *
     * @author zhanghengfeng
     * @date 2024-12-19 10:12:56
     * @type {string}
     */
    E(this, "groupField", "");
    /**
     * 第一列名称
     *
     * @author zhanghengfeng
     * @date 2024-12-19 10:12:30
     * @type {string}
     */
    E(this, "firstColName", "");
  }
  async onInit() {
    const s = this.model.columns.find(
      (i) => {
        var n;
        return (n = i.source) == null ? void 0 : n.groupItem;
      }
    );
    s && (this.groupField = s.codeName);
    const o = this.model.columns.find((i) => i.codeName !== this.groupField && !i.source.hideDefault && !i.source.hiddenDataItem);
    o && (this.firstColName = o.codeName), await super.onInit();
  }
  /**
   * 部件加载后处理
   *
   * @author lxm
   * @date 2022-08-19 14:08:50
   */
  async afterLoad(s) {
    return await Promise.allSettled(
      Object.values(this.fieldColumns).map(async (o) => {
        await o.loadCodeList();
      })
    ), this.rows = s.map((o) => {
      const i = new X(o, this);
      return this.gridStateNotify(i, ve.LOAD), i;
    }), this.handleGroup(s), s;
  }
  /**
   * 处理分组数据
   * @param {ControlVO} items
   * @return {*}
   * @author: zhujiamin
   * @Date: 2023-10-09 14:03:17
   */
  handleGroup(s) {
    const o = /* @__PURE__ */ new Map();
    s.forEach((i) => {
      const n = i[this.groupField];
      o.has(n) || o.set(n, []), o.has(n) && o.get(n).push(i);
    }), this.groups = [], o.forEach((i, n) => {
      this.groups.push({
        caption: `${n}`,
        key: n,
        children: i
      });
    });
  }
}
function rt(e, t, s, o = {}) {
  return Le(e, () => {
    const i = new nt(t, s, o);
    return z(e, "gridRowActiveMode", i.setGridRowActiveMode.bind(i)), i;
  });
}
const at = k({
  props: {
    modelData: he,
    context: {
      type: Object,
      required: !0
    },
    params: {
      type: Object,
      default: () => ({})
    },
    /**
     * 表格行数据默认激活模式
     * - 0 不激活
     * - 1 单击激活
     * - 2 双击激活(默认值)
     *
     * @type {(number | 0 | 1 | 2)}
     */
    gridRowActiveMode: {
      type: Number,
      default: 2
    },
    modal: {
      type: Object
    }
  },
  setup(e) {
    const {
      proxy: t
    } = R(), s = U("grid"), o = rt(t, e.modelData, e.context, e.params), [i] = st(o), {
      onRowClick: n,
      onDbRowClick: r,
      onSelectionChange: a,
      onSortChange: d
    } = ot(o), {
      onPageChange: h,
      onPageReset: m,
      onPageSizeChange: f
    } = it(o), C = (L, S) => {
      const l = t.$refs.grid;
      l && (l.toggleSelect && l.toggleSelect(S), l.highlightCurrentRow && l.highlightCurrentRow(S)), n(L);
    }, b = g(0), F = g(null), v = g(null);
    let p = null, y = 0;
    const I = () => {
      var L;
      if (F.value && ((L = e.modal) == null ? void 0 : L.mode) !== "EMBED")
        if (o.model.source.enablePagingBar && v.value) {
          const S = v.value.$el, l = S.offsetHeight + parseFloat(window.getComputedStyle(S).paddingTop);
          b.value = F.value.offsetHeight - l;
        } else
          b.value = F.value.offsetHeight;
      o.model.source.height > 0 && (b.value = o.model.source.height);
    };
    N(F, (L, S) => {
      L && L !== S && (I(), window.ResizeObserver && F.value && (p = new ResizeObserver((l) => {
        const u = l[0].contentRect.height;
        u !== y && (I(), y = u);
      }), p.observe(F.value)));
    }), be(() => {
      p && p.disconnect();
    });
    const O = T(() => {
      const L = [];
      return o.groups.forEach((S) => {
        if (!S.children.length)
          return;
        const u = [...S.children].shift();
        L.push({
          srfkey: S.caption,
          isGroupData: !0,
          first: u,
          children: S.children,
          _showChildren: !0
        });
      }), L;
    });
    return {
      c: o,
      ns: s,
      columns: i,
      tableData: O,
      onDbRowClick: r,
      onUIRowClick: C,
      onSelectionChange: a,
      onSortChange: d,
      onPageChange: h,
      onPageSizeChange: f,
      onPageReset: m,
      tableHeight: b,
      gridRef: F,
      girdPaginationRef: v
    };
  },
  render() {
    if (!this.c.complete)
      return;
    const e = {};
    return this.c.model.columns.forEach((t) => {
      if (t.source.columnType === "GROUPGRIDCOLUMN")
        return;
      const s = t.codeName;
      e[s] = (o) => {
        const {
          row: i,
          column: n
        } = o;
        if (i.isGroupData && n.key === this.c.firstColName)
          return c("div", {
            class: this.ns.b("sum"),
            attrs: {
              title: i.first[this.c.groupField]
            }
          }, [c("span", [i.first[this.c.groupField]])]);
        const r = this.c.rows.find((a) => a.data.srfkey === i.srfkey);
        if (r)
          return c(this.c.providers[s].component, {
            props: {
              controller: this.c.columns[s],
              row: r
            },
            key: i.srfkey + s
          });
      };
    }), c("control-layout", {
      attrs: {
        modelData: this.c.model
      }
    }, [c("div", {
      ref: "gridRef",
      class: [this.ns.b(), this.ns.b("group-grid"), this.ns.is("show-header", !this.c.model.source.hideHeader), this.ns.is("enable-page", this.c.model.source.enablePagingBar)]
    }, [this.c.groups.length > 0 && c("i-table", {
      ref: "grid",
      attrs: {
        height: this.tableHeight,
        "show-header": !this.c.model.source.hideHeader,
        "highlight-row": !0,
        data: this.tableData,
        columns: this.columns,
        "row-key": "srfkey"
      },
      class: this.ns.b("content"),
      on: {
        "on-row-click": this.onUIRowClick,
        "on-row-dblclick": this.onDbRowClick,
        "on-selection-change": this.onSelectionChange,
        "on-sort-change": this.onSortChange
      },
      scopedSlots: e
    }), this.c.model.source.enablePagingBar && c("app-grid-pagination", {
      ref: "girdPaginationRef",
      attrs: {
        total: this.c.total,
        curPage: this.c.curPage,
        size: this.c.size
      },
      on: {
        change: this.onPageChange,
        "page-size-change": this.onPageSizeChange,
        "page-reset": this.onPageReset
      }
    })])]);
  }
});
class lt {
  constructor() {
    E(this, "component", Oe);
  }
}
class ct {
  constructor() {
    E(this, "component", Me);
  }
  async createController(t, s) {
    const o = new Z(t, s);
    return await o.init(), o;
  }
}
class dt {
  constructor() {
    E(this, "component", "IndexView");
  }
}
const ae = k({
  name: "WFStepTraceGrid",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    },
    deName: {
      type: String,
      required: !0
    }
  },
  setup(e) {
    const {
      proxy: t
    } = R(), s = Ue(t, e.modelPath);
    z(t, "deName", s.setDeName.bind(s));
    const o = U("wf-step-trace-grid"), i = g([]), n = (a, d, h = !1) => {
      a.identitylinks.length > 0 || a.comments.length > 0 && a.comments.forEach((m) => {
        var f, C, b;
        h && m.type === "启动流程" || d.push({
          id: W(),
          nodeName: a.userTaskName,
          personName: (f = m.authorName) == null ? void 0 : f.replace(/\([^)]*\)[^(]*$/, ""),
          deptName: ((b = (C = m.authorName) == null ? void 0 : C.match(/.*\(([^)]*)\)[^(]*$/)) == null ? void 0 : b[1]) || "",
          time: m.time,
          content: m.type,
          comment: m.fullMessage
        });
      });
    };
    s.nerve.self.evt.on("mounted", () => {
      var a;
      s.data && ((a = s.data.usertasks) == null || a.forEach((d) => {
        if (d.usertasks && d.usertasks.length > 0) {
          const h = [];
          d.usertasks.forEach((m) => {
            n(m, h, !0);
          }), i.value.push({
            id: W(),
            nodeName: `${d.userTaskName}`,
            personName: "",
            deptName: "",
            time: "",
            content: "",
            comment: "",
            children: h,
            _showChildren: !0
          });
        } else
          n(d, i.value);
      }), i.value.sort((d, h) => Date.parse(d.time) - Date.parse(h.time)));
    });
    const r = g([{
      title: "序号",
      key: "index",
      width: 60,
      resizable: !0,
      render: (a, d) => i.value.findIndex((m) => m.id === d.row.id) === -1 ? null : a("span", {
        style: {
          textAlign: "center"
        }
      }, d.index + 1)
    }, {
      title: "审批人",
      key: "personName",
      width: 180,
      tree: !0,
      resizable: !0
    }, {
      title: "审批部门",
      key: "deptName",
      width: 170,
      resizable: !0
    }, {
      title: "处理环节",
      key: "nodeName",
      width: 200,
      resizable: !0,
      className: "clhj"
    }, {
      title: "审批(递交时间)",
      key: "time",
      width: 170,
      resizable: !0
    }, {
      title: "审批动作",
      key: "content",
      width: 150,
      resizable: !0
    }, {
      title: "审批意见",
      key: "comment",
      width: 100
    }]);
    return {
      c: s,
      ns: o,
      gridData: i,
      columns: r
    };
  },
  render() {
    return c("div", {
      class: this.ns.b()
    }, [c("div", {
      class: this.ns.e("title")
    }, ["审批信息"]), c("i-table", {
      attrs: {
        "disabled-hover": !0,
        columns: this.columns,
        data: this.gridData,
        "row-key": "id"
      },
      class: this.ns.e("grid")
    })]);
  }
});
class ut extends we {
  async calcWfToolbar() {
    await super.calcWfToolbar(), this.isEditable && this.wfLinks.unshift({
      sequenceFlowName: "保存",
      type: "FORM_SAVE"
    });
  }
  async onLinkClick(t) {
    t.type === "FORM_SAVE" ? await this.save() : super.onLinkClick(t);
  }
}
k({
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    }
  },
  setup(e) {
    const {
      proxy: t
    } = R(), s = Q(t, (r, a) => new ut(e.modelPath, r, a)), o = U(`view-${me.DE_WF_DYNA_EDIT_VIEW3}`.toLowerCase()), i = g(["mainForm"]);
    return {
      c: s,
      ns: o,
      onTabClick: (r) => {
        i.value.includes(r) || i.value.push(r);
      },
      lazyList: i
    };
  },
  render(e) {
    const t = [];
    if (this.c.complete) {
      const {
        activeForm: s
      } = this.c;
      s && this.c.providers[s.name] && t.push(e(this.c.providers[s.name].component, {
        props: {
          modelData: s,
          context: this.c.context,
          params: this.c.params
        },
        style: {
          height: "auto"
        },
        on: {
          neuronInit: this.c.nerve.onNeuronInit("form")
        }
      }));
    }
    if (this.c.complete && this.c.model.drTab.pages[0]) {
      const s = this.c.model.drTab.pages[0], o = this.c.drPages[s.source.name];
      t.push(e(ae, {
        attrs: {
          context: o.context,
          params: o.params,
          deName: this.c.model.appEntity.source.codeName,
          modal: this.modal,
          modelPath: s.embedView.source.modelPath
        }
      }));
    }
    return e("view-base", {
      attrs: {
        controller: this.c
      },
      scopedSlots: {
        toolbar: () => this.c.complete ? [this.c.wfLinks.length > 0 && e("wf-toolbar", {
          attrs: {
            wfLinks: this.c.wfLinks
          },
          on: {
            "wf-link-click": (s) => {
              this.c.onLinkClick(s);
            }
          }
        })] : null
      }
    }, [this.c.complete && e("i-tabs", {
      class: [this.ns.be("", "tab")],
      attrs: {
        name: this.c.model.drTab.source.name
      },
      on: {
        "on-click": this.onTabClick
      }
    }, [e("i-tab-pane", {
      class: this.ns.be("", "tab-item"),
      attrs: {
        tab: this.c.model.drTab.source.name,
        label: this.c.model.drTab.source.editItemCaption,
        name: "mainForm"
      }
    }, [t]), this.c.model.drTab.pages.map((s) => {
      const o = this.c.drPages[s.source.name];
      return e("i-tab-pane", {
        class: this.ns.be("", "tab-item"),
        attrs: {
          tab: this.c.model.drTab.source.name,
          disabled: this.c.isNewData,
          label: s.source.caption,
          name: s.source.name
        }
      }, [!this.c.isNewData && this.lazyList.includes(s.source.name) && e("ViewShell", {
        attrs: {
          context: o.context,
          params: o.params,
          modal: {
            mode: ee.EMBED
          },
          modelPath: s.embedView.source.modelPath,
          // 流程跟踪视图用
          deName: this.c.model.appEntity.source.codeName
        },
        on: {
          neuronInit: this.c.nerve.onNeuronInit(s.source.name)
        },
        key: o.key
      })]);
    })])]);
  }
});
k({
  name: "SyEditView3",
  props: {
    context: Object,
    params: {
      type: Object
    },
    modelPath: {
      type: String,
      required: !0
    },
    modal: {
      type: Object
    }
  },
  setup(e) {
    const {
      proxy: t
    } = R(), s = Ee(t, e.modelPath), o = U("view-deeditview3"), i = g(["mainForm"]);
    return {
      c: s,
      ns: o,
      onTabClick: (r) => {
        i.value.includes(r) || i.value.push(r);
      },
      lazyList: i
    };
  },
  render(e) {
    return e("view-base", {
      attrs: {
        controller: this.c
      }
    }, [this.c.complete && e("i-tabs", {
      class: [this.ns.be("", "tab")],
      attrs: {
        name: this.c.model.drTab.source.name
      },
      on: {
        "on-click": this.onTabClick
      }
    }, [e("i-tab-pane", {
      class: this.ns.be("", "tab-item"),
      attrs: {
        tab: this.c.model.drTab.source.name,
        label: this.c.model.drTab.source.editItemCaption,
        name: "mainForm"
      }
    }, [e("edit-form-control", {
      attrs: {
        modelData: this.c.model.form,
        context: this.c.context,
        params: this.c.params
      },
      style: {
        height: "auto"
      },
      on: {
        neuronInit: this.c.nerve.onNeuronInit(this.c.model.form.source.name)
      }
    }), e(ae, {
      attrs: {
        context: this.c.drPages[this.c.model.drTab.pages[0].source.name].context,
        params: this.c.drPages[this.c.model.drTab.pages[0].source.name].params,
        deName: this.c.model.appEntity.source.codeName,
        modal: this.modal,
        modelPath: this.c.model.drTab.pages[0].embedView.source.modelPath
      }
    })]), this.c.model.drTab.pages.map((t) => {
      const s = this.c.drPages[t.source.name];
      if (s)
        return e("i-tab-pane", {
          class: this.ns.be("", "tab-item"),
          attrs: {
            tab: this.c.model.drTab.source.name,
            disabled: this.c.isNewData,
            label: t.source.caption,
            name: t.source.name
          }
        }, [!this.c.isNewData && this.lazyList.includes(t.source.name) && e("ViewShell", {
          attrs: {
            context: s.context,
            params: s.params,
            modal: {
              mode: ee.EMBED
            },
            modelPath: t.embedView.source.modelPath,
            // 流程跟踪视图用
            deName: this.c.model.appEntity.source.codeName
          },
          on: {
            neuronInit: this.c.nerve.onNeuronInit(t.source.name)
          },
          key: s.key
        })]);
    })])]);
  }
});
class ht {
  constructor() {
    E(this, "formEditor", "SyFileUpload");
    E(this, "gridEditor", "SyGridFileUploadContainer");
  }
  async createController(t, s) {
    const o = new J(t, s);
    return await o.init(), o;
  }
}
class mt extends te {
  async execAction(t, s, o, i, n) {
    if (o && o.length > 0) {
      const a = (await ibiz.entityService.getService("XQFBXQPS", s)).local.getList(s);
      o.forEach((d) => {
        const h = a.find((m) => m.srfkey === d.srfkey);
        h && (h.psjg = "10", d.psjg = "10");
      });
    }
    return {
      refresh: !1,
      closeView: !1
    };
  }
}
class pt {
  constructor() {
    E(this, "handler");
  }
  async getHandler() {
    return this.handler || (this.handler = new mt()), this.handler;
  }
}
class ft extends te {
  async execAction(t, s, o, i, n) {
    if (o && o.length > 0) {
      const a = (await ibiz.entityService.getService("XQFBXQPS", s)).local.getList(s);
      o.forEach((d) => {
        const h = a.find((m) => m.srfkey === d.srfkey);
        h && (h.psjg = "20", d.psjg = "20");
      });
    }
    return {
      refresh: !1,
      closeView: !1
    };
  }
}
class gt {
  constructor() {
    E(this, "handler");
  }
  async getHandler() {
    return this.handler || (this.handler = new ft()), this.handler;
  }
}
class vt {
  constructor() {
    E(this, "component", "GroupGrid");
  }
}
const wt = new Ae(import.meta.url), Nt = {
  mateUrl: import.meta.url,
  install(e) {
    pe.getModelService().then((t) => {
      var o;
      ((o = t.app.userParams) == null ? void 0 : o.autoWidth) === "true" && document.getElementsByClassName("app")[0].classList.add("auto-width");
    }), wt.loadStyle(["/style.css"]), ibiz.config.enableDataInfoBar = !1, ibiz.config.gridEditShowMode = "all", e.component("WfToolbar", Be), ibiz.register.view.register(
      "VIEW_CUSTOM_SyWebIndexView",
      new dt()
    ), ibiz.register.view.register(
      "VIEW_CUSTOM_PresetWFChartView",
      new lt()
    ), ibiz.register.gridColumn.register(
      "GRID_COLRENDER_CodeListGridColumn",
      new ct()
    ), e.component("SyFileUpload", Xe), e.component("SyGridFileUpload", Je), e.component("SyEditGridFileUpload", Ye), e.component("SyGridFileUploadContainer", Qe), ibiz.register.editor.register(
      "EDITOR_CUSTOMSTYLE_SyFileUpload",
      new ht()
    ), e.component("AppLayout", et), ibiz.register.uiAction.register(
      "DEUIACTION_BatchApprovalOrdersId",
      new pt()
    ), ibiz.register.uiAction.register(
      "DEUIACTION_BatchNoApprovalOrdersId",
      new gt()
    ), e.component("GroupGrid", at), ibiz.register.control.register(
      "GRID_RENDER_GROUP_GRID",
      new vt()
    );
  }
};
export {
  Nt as default
};
