import { defineComponent } from 'vue';
import {
  getGridInputProps,
  useGridCellEditor,
  useNamespace,
} from '@ibiz-template/vue-util';

export const IBizGridCheckbox = defineComponent({
  name: 'IBizGridCheckbox',
  props: getGridInputProps(),
  setup(props) {
    const ns = useNamespace('grid-checkbox');

    const { isInfoMode, componentRef, onOperateChange, onChange } =
      useGridCellEditor(props.rowDataChange, props.rowSave, {
        isDelaySave: true,
      });

    return {
      ns,
      isInfoMode,
      componentRef,
      onOperateChange,
      onChange,
    };
  },
  render(h) {
    return (
      <grid-editor
        disabled={this.disabled}
        readonly={this.readonly}
        ref='componentRef'
        class={`${this.ns.b()}`}
      >
        {h('IBizCheckbox', {
          props: {
            ...this.$props,
            readonly: this.readonly || this.isInfoMode,
            disabled: this.disabled,
          },
          on: {
            change: this.onChange,
            operate: this.onOperateChange,
          },
        })}
      </grid-editor>
    );
  },
});
