import {
  IGridColumnProvider,
  GridController,
  GridFieldColumnController,
} from '@ibiz-template/controller';
import { GridFieldColumnModel } from '@ibiz-template/model';
/**
 * 表格列适配器
 *
 * @author lxm
 * @date 2022-09-19 22:09:03
 * @export
 * @class GridFieldColumnProvider
 * @implements {IGridColumnProvider}
 */
export class GridFieldColumnProvider implements IGridColumnProvider {
  component: string = 'GridFieldColumn';

  async createController(
    columnModel: GridFieldColumnModel,
    grid: GridController,
  ): Promise<GridFieldColumnController> {
    const c = new GridFieldColumnController(columnModel, grid);
    await c.init();
    return c;
  }
}
