import { logger } from '@/core';
import { address } from 'ip';
import { isNilOrEmpty } from 'qx-util';

/**
 * 获取本机ip地址
 *
 * @author chitanda
 * @date 2021-08-15 15:08:09
 * @export
 * @return {*}  {string}
 */
export function getLocalIP(): string {
  const ip = address();
  if (isNilOrEmpty(ip)) {
    logger.error('本地 ip 计算异常!');
  }
  return ip;
}

/**
 * 获取时间戳路径
 *
 * @author chitanda
 * @date 2021-10-29 14:10:02
 * @export
 * @param {number} [num=5] 默认时间戳后拼接5个随机数
 * @return {*}  {string}
 */
export function getTimePath(num = 5): string {
  let path = new Date().getTime().toString();
  if (num > 0) {
    path += Math.floor(Math.random() * Math.pow(10, num)).toString();
  }
  return path;
}
